/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template;

import com.mhdt.Print;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import online.sanen.cdm.template.InvalidResultSetAccessException;
import online.sanen.cdm.template.JdbcUtils;
import online.sanen.cdm.template.RowExtractor;
import online.sanen.cdm.template.jpa.JPA;

public class RowExtractor2Entry<T>
implements RowExtractor<T> {
    Class<T> cls;
    private Map<Integer, String> columnLabelMap;

    public RowExtractor2Entry(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        if (this.columnLabelMap == null) {
            this.initColumnLabelMap(rs);
        }
        return this.parse(rs);
    }

    public T parse(ResultSet rs) throws SQLException {
        T t = null;
        try {
            t = this.cls.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e1) {
            Print.error((Object)"Init faild: because bean has not constructor default");
            e1.printStackTrace();
            return null;
        }
        for (int i = 1; i <= this.columnLabelMap.size(); ++i) {
            String key = this.columnLabelMap.get(i);
            Object resultSetValue = JdbcUtils.getResultSetValue(rs, i);
            JPA.setInject(t, key, resultSetValue);
        }
        return t;
    }

    private void initColumnLabelMap(ResultSet resultSet) {
        try {
            ResultSetMetaData rsmd = resultSet.getMetaData();
            if (rsmd != null) {
                int columnCount = rsmd.getColumnCount();
                this.columnLabelMap = new HashMap<Integer, String>(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = JdbcUtils.lookupColumnName(rsmd, i);
                    if (this.columnLabelMap.containsValue(columnName)) continue;
                    this.columnLabelMap.put(i, columnName);
                }
            } else {
                this.columnLabelMap = Collections.emptyMap();
            }
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }
}

