/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template;

import com.mhdt.analyse.Validate;
import com.mhdt.log.Log;
import com.mhdt.toolkit.NumberUtilly;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;

public class JdbcUtils {
    private static final Log logger = Log.getDefaultLog();
    private static final boolean getObjectWithTypeAvailable = Validate.hasMethod(ResultSet.class, (String)"getObject", (Class[])new Class[]{Integer.TYPE, Class.class});

    public static String lookupColumnName(ResultSetMetaData rsmd, int columnIndex) throws SQLException {
        String name = rsmd.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = rsmd.getColumnName(columnIndex);
        }
        return name;
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            obj = blob.getBytes(1L, (int)blob.length());
        } else if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            obj = clob.getSubString(1L, (int)clob.length());
        } else if ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className)) {
            obj = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    public static Object getResultSetValue(ResultSet rs, int index, Class<?> requiredType) throws SQLException {
        Comparable<Boolean> value;
        if (requiredType == null) {
            return JdbcUtils.getResultSetValue(rs, index);
        }
        if (String.class == requiredType) {
            return rs.getString(index);
        }
        if (Boolean.TYPE == requiredType || Boolean.class == requiredType) {
            value = rs.getBoolean(index);
        } else if (Byte.TYPE == requiredType || Byte.class == requiredType) {
            value = rs.getByte(index);
        } else if (Short.TYPE == requiredType || Short.class == requiredType) {
            value = rs.getShort(index);
        } else if (Integer.TYPE == requiredType || Integer.class == requiredType) {
            value = rs.getInt(index);
        } else if (Long.TYPE == requiredType || Long.class == requiredType) {
            value = rs.getLong(index);
        } else if (Float.TYPE == requiredType || Float.class == requiredType) {
            value = Float.valueOf(rs.getFloat(index));
        } else if (Double.TYPE == requiredType || Double.class == requiredType || Number.class == requiredType) {
            value = rs.getDouble(index);
        } else {
            String typeName;
            if (BigDecimal.class == requiredType) {
                return rs.getBigDecimal(index);
            }
            if (Date.class == requiredType) {
                return rs.getDate(index);
            }
            if (Time.class == requiredType) {
                return rs.getTime(index);
            }
            if (Timestamp.class == requiredType || java.util.Date.class == requiredType) {
                return rs.getTimestamp(index);
            }
            if (byte[].class == requiredType) {
                return rs.getBytes(index);
            }
            if (Blob.class == requiredType) {
                return rs.getBlob(index);
            }
            if (Clob.class == requiredType) {
                return rs.getClob(index);
            }
            if (requiredType.isEnum()) {
                Object obj = rs.getObject(index);
                if (obj instanceof String) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return NumberUtilly.convertNumberToTargetClass((Number)((Number)obj), Integer.class);
                }
                return rs.getString(index);
            }
            if (getObjectWithTypeAvailable) {
                try {
                    return rs.getObject(index, requiredType);
                }
                catch (AbstractMethodError err) {
                    logger.debug((Object)"JDBC driver does not implement JDBC 4.1 'getObject(int, Class)' method");
                }
                catch (SQLFeatureNotSupportedException ex) {
                    logger.debug((Object)"JDBC driver does not support JDBC 4.1 'getObject(int, Class)' method");
                }
                catch (SQLException ex) {
                    logger.debug((Object)"JDBC driver has limited support for JDBC 4.1 'getObject(int, Class)' method");
                }
            }
            if ("LocalDate".equals(typeName = requiredType.getSimpleName())) {
                return rs.getDate(index);
            }
            if ("LocalTime".equals(typeName)) {
                return rs.getTime(index);
            }
            if ("LocalDateTime".equals(typeName)) {
                return rs.getTimestamp(index);
            }
            return JdbcUtils.getResultSetValue(rs, index);
        }
        return rs.wasNull() ? null : value;
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                logger.debug((Object)"Could not close JDBC Statement");
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing JDBC Statement");
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                logger.debug((Object)"Could not close JDBC ResultSet");
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing JDBC ResultSet");
            }
        }
    }

    public static boolean supportsBatchUpdates(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            if (dbmd != null && dbmd.supportsBatchUpdates()) {
                return true;
            }
        }
        catch (SQLException ex) {
            logger.debug((Object)"JDBC driver 'supportsBatchUpdates' method threw exception");
        }
        return false;
    }
}

