/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template;

import com.mhdt.toolkit.Assert;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import online.sanen.cdm.template.transaction.JdbcTransaction;
import online.sanen.cdm.template.transaction.Transaction;

public class DataSourceUtils {
    public static Connection getConnection(Transaction transaction, DataSource dataSource) throws SQLException {
        if (transaction != null) {
            return transaction.getConnection();
        }
        return DataSourceUtils.fetchConnection(dataSource);
    }

    private static Connection fetchConnection(DataSource dataSource) throws SQLException {
        Connection con = dataSource.getConnection();
        if (con == null) {
            throw new IllegalStateException("DataSource returned null from getConnection(): " + dataSource);
        }
        return con;
    }

    public static void releaseConnection(Transaction transaction, Connection con) {
        if (transaction != null) {
            if (!(transaction instanceof JdbcTransaction)) {
                try {
                    transaction.close();
                }
                catch (SQLException sQLException) {}
            }
        } else {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void applyTimeout(Statement stmt, DataSource dataSource, int queryTimeout) throws SQLException {
        Assert.notNull((Object)stmt, (String)"No Statement specified");
        if (queryTimeout >= 0) {
            stmt.setQueryTimeout(queryTimeout);
        }
    }
}

