/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.template;

import com.mhdt.toolkit.Assert;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import online.sanen.cdm.template.ResultSetExtractor;
import online.sanen.cdm.template.RowExtractor;

public class ResultSetExtractor2List<T>
implements ResultSetExtractor<List<T>> {
    private final RowExtractor<T> rowMapper;
    private final int rowsExpected;

    public ResultSetExtractor2List(RowExtractor<T> rowMapper) {
        this(rowMapper, 0);
    }

    public ResultSetExtractor2List(RowExtractor<T> rowMapper, int rowsExpected) {
        Assert.notNull(rowMapper, (String)"RowMapper is required");
        this.rowMapper = rowMapper;
        this.rowsExpected = rowsExpected;
    }

    @Override
    public List<T> extractData(ResultSet rs) throws SQLException {
        ArrayList<T> results = this.rowsExpected > 0 ? new ArrayList<T>(this.rowsExpected) : new ArrayList();
        int rowNum = 0;
        while (rs.next()) {
            results.add(this.rowMapper.mapRow(rs, rowNum++));
        }
        return results;
    }
}

