/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.springSupport;

import com.mhdt.degist.Validate;
import com.mhdt.toolkit.Reflect;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import online.sanen.cdm.api.Bootstrap;
import online.sanen.cdm.api.QueryMap;
import online.sanen.cdm.api.QuerySql;
import online.sanen.cdm.api.QueryTable;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.condition.Condition;
import online.sanen.cdm.springSupport.GenaralAnalyse;
import online.sanen.cdm.springSupport.GeneralDao;
import online.sanen.cdm.template.jpa.JPA;
import online.sanen.cdm.template.jpa.Table;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public abstract class GeneralDaoImpl<T>
implements GeneralDao<T>,
ApplicationListener<ContextRefreshedEvent> {
    private ApplicationContext applicationContext = null;
    private JPA.Primarykey primaryKey;
    private String defaultTableName;
    private Bootstrap bootstrap;
    private Class<T> cls;

    public final void onApplicationEvent(ContextRefreshedEvent event) {
        this.applicationContext = event.getApplicationContext();
        this.bootstrap = this.initBootstrap();
        System.err.println("Init Cdm-for-Spring :" + this.getDefaultTableName());
        this.afterInitialization();
    }

    protected void afterInitialization() {
    }

    private JPA.Primarykey getPrimaryKey() {
        if (this.primaryKey == null) {
            try {
                Object basicBean = Reflect.newInstance((String)this.getEntry().getName());
                this.primaryKey = Cdm.getPrimaryKey(basicBean.getClass());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return this.primaryKey;
    }

    @Override
    public int insert(List<T> entrys) {
        return this.getBootStrap().query(entrys).insert();
    }

    @Override
    public final int delete(Object object) {
        return this.getBootStrap().query(this.getEntry(), GenaralAnalyse.processPrimaryKey(object)).delete();
    }

    @Override
    public final int update(T entry) {
        return this.getBootStrap().query(entry).update();
    }

    @Override
    public final int update(List<T> entrys) {
        return this.getBootStrap().query(entrys).update();
    }

    @Override
    public final T find(Object primarykey) {
        return (T)this.getBootStrap().query(this.getEntry(), GenaralAnalyse.processPrimaryKey(primarykey)).find();
    }

    @Override
    public T find(Consumer<List<Condition>> conds) {
        return (T)this.queryTB().addCondition(conds).unique();
    }

    @Override
    public final int insert(T entry) {
        if (entry == null) {
            throw new NullPointerException("Entry is null");
        }
        return this.getBootStrap().query(entry).insert();
    }

    @Override
    public int insert(T entry, String ... exceptfields) {
        if (entry == null) {
            throw new NullPointerException("Entry is null");
        }
        return this.getBootStrap().query(entry).setExceptFields(exceptfields).insert();
    }

    @Override
    public int insert(List<T> entrys, String ... exceptfields) {
        if (entrys == null || entrys.isEmpty()) {
            throw new NullPointerException("Entrys is null or is empty");
        }
        return this.getBootStrap().query(entrys).setExceptFields(exceptfields).insert();
    }

    @Override
    public final List<T> all() {
        return this.queryTB().list();
    }

    @Override
    public List<T> all(Consumer<List<Condition>> consumer) {
        return this.queryTB().addCondition(consumer).list();
    }

    @Override
    public final int count() {
        return (Integer)this.getBootStrap().createSQL("select count(1) from " + this.getDefaultTableName()).unique();
    }

    public final String getDefaultTableName() {
        if (this.defaultTableName == null) {
            this.defaultTableName = Reflect.hasAnnotation(this.getEntry(), Table.class) ? JPA.getTableName(this.getEntry()).toUpperCase() : this.getEntry().getSimpleName().toUpperCase();
        }
        return this.defaultTableName;
    }

    protected final QueryTable queryTB() {
        return this.getBootStrap().queryTable(this.getDefaultTableName());
    }

    protected final QuerySql createSQL(String sql, Object ... paramers) {
        return this.getBootStrap().createSQL(sql, paramers);
    }

    protected final QuerySql createSQLForEntry(String sql, Object ... paramers) {
        return this.getBootStrap().createSQL(sql, paramers);
    }

    protected final QueryMap queryMap(Map<String, Object> map) {
        return this.getBootStrap().queryMap(this.getDefaultTableName(), map);
    }

    protected Bootstrap initBootstrap() {
        Bootstrap bootstrap = null;
        if (this.applicationContext == null) {
            throw new NullPointerException("ApplicationListener Uninitialized.");
        }
        if (Validate.isNullOrEmpty((Object)this.applyBootStrapBeanId())) {
            try {
                bootstrap = (Bootstrap)this.applicationContext.getBean(Bootstrap.class);
            }
            catch (NoUniqueBeanDefinitionException e) {
                bootstrap = (Bootstrap)this.applicationContext.getBeansOfType(Bootstrap.class).values().iterator().next();
            }
        } else {
            bootstrap = (Bootstrap)this.applicationContext.getBean(this.applyBootStrapBeanId(), Bootstrap.class);
        }
        return bootstrap;
    }

    protected String applyBootStrapBeanId() {
        String id = JPA.getBootStrapId(this.getEntry());
        if (Validate.isNullOrEmpty((Object)id)) {
            id = JPA.getBootStrapId(this.getClass());
        }
        if (!Validate.isNullOrEmpty((Object)id)) {
            return id;
        }
        return null;
    }

    public final Class<T> getEntry() {
        if (this.cls == null) {
            Class<?> targetClass = null;
            if (this.getClass().getName().contains("$")) {
                try {
                    targetClass = Class.forName(this.getClass().getName().substring(0, this.getClass().getName().indexOf("$")), false, this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                targetClass = this.getClass();
            }
            this.cls = (Class)Reflect.getGeneric(targetClass);
        }
        return this.cls;
    }

    @Override
    public boolean create() throws ReflectiveOperationException {
        if (!this.getBootStrap().dataInformation().containsTable(this.getDefaultTableName())) {
            this.getBootStrap().query(Reflect.newInstance((String)this.getEntry().getName())).create();
            return true;
        }
        return false;
    }

    @Override
    public Bootstrap getBootStrap() {
        return this.bootstrap;
    }
}

