/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.springSupport;

import com.mhdt.analyse.Validate;
import com.mhdt.annotation.TableName;
import com.mhdt.toolkit.Reflect;
import java.util.List;
import online.sanen.cdm.Bootstrap;
import online.sanen.cdm.QuerySQL;
import online.sanen.cdm.QueryTB;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.Condition;
import online.sanen.cdm.springSupport.GenaralAnalyse;
import online.sanen.cdm.springSupport.GeneralDao;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public abstract class GeneralDaoImpl<T extends BasicBean>
implements GeneralDao<T>,
ApplicationListener<ContextRefreshedEvent>,
BeanPostProcessor {
    private static ApplicationContext applicationContext = null;
    private String defaultTableName;
    private Bootstrap bootstrap;
    private Class<T> cls;

    public final void onApplicationEvent(ContextRefreshedEvent event) {
        if (applicationContext == null) {
            applicationContext = event.getApplicationContext();
        }
        System.err.println("Init Cdm-for-Spring " + this.getEntry().getName());
    }

    @Override
    public final int insert(T entry) {
        return this.getBootstrap().query(entry).insert();
    }

    @Override
    public final int remove(Object object) {
        return this.getBootstrap().query(this.getEntry(), GenaralAnalyse.processPrimaryKey(object)).remove();
    }

    @Override
    public final int update(T entry) {
        return this.getBootstrap().query(entry).update();
    }

    @Override
    public final T find(Object primarykey) {
        return (T)this.getBootstrap().query(this.getEntry(), GenaralAnalyse.processPrimaryKey(primarykey)).find();
    }

    @Override
    public final List<T> all() {
        return this.getBootstrap().query(this.getDefaultTableName()).addEntry(this.getEntry()).list();
    }

    @Override
    public final Object maximumkey() {
        try {
            BasicBean basicBean = (BasicBean)Reflect.newInstance((String)this.getEntry().getName());
            return this.getBootstrap().createSQL("SELECT MAX(?) FROM " + this.getDefaultTableName(), new Object[]{basicBean.getPrimarykey()}).uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final int totalNumber() {
        return (Integer)this.getBootstrap().createSQL("select count(1) from " + this.getDefaultTableName()).uniqueResult();
    }

    @Override
    public final int remove(String fieldName, Object value) {
        return this.getBootstrap().query(this.getDefaultTableName()).addCondition(fieldName, Condition.Conditions.EQUALS, value).remove();
    }

    @Override
    public final T find(String fieldName, Object value) {
        return (T)((BasicBean)this.getBootstrap().query(this.getDefaultTableName()).addCondition(fieldName, Condition.Conditions.EQUALS, value).addEntry(this.getEntry()).uniqueResult());
    }

    private final String getDefaultTableName() {
        if (this.defaultTableName == null) {
            this.defaultTableName = Reflect.hasAnnotation(this.getEntry(), TableName.class) ? Reflect.getTableNameValue(this.getEntry()).toUpperCase() : this.getEntry().getSimpleName().toUpperCase();
        }
        return this.defaultTableName;
    }

    protected final QueryTB queryTB() {
        return this.getBootstrap().query(this.getDefaultTableName());
    }

    protected final QueryTB queryTBForEntry() {
        return this.getBootstrap().query(this.getDefaultTableName()).addEntry(this.getEntry());
    }

    protected final QuerySQL createSQL(String sql, Object ... paramers) {
        return this.getBootstrap().createSQL(sql, paramers);
    }

    protected final QuerySQL createSQLForEntry(String sql, Object ... paramers) {
        return this.getBootstrap().createSQL(sql, paramers).addEntry(this.getEntry());
    }

    protected final Bootstrap getBootstrap() {
        if (this.bootstrap == null) {
            if (Validate.isNullOrEmpty((Object)this.applyBootStrapBeanId())) {
                try {
                    this.bootstrap = (Bootstrap)applicationContext.getBean(Bootstrap.class);
                }
                catch (NoUniqueBeanDefinitionException e) {
                    this.bootstrap = (Bootstrap)applicationContext.getBeansOfType(Bootstrap.class).values().iterator().next();
                }
            } else {
                this.bootstrap = (Bootstrap)applicationContext.getBean(this.applyBootStrapBeanId(), Bootstrap.class);
            }
        }
        return this.bootstrap;
    }

    protected String applyBootStrapBeanId() {
        String id = Reflect.getBootStrapID(this.getEntry().getClass());
        if (Validate.isNullOrEmpty((Object)id)) {
            id = Reflect.getBootStrapID(this.getClass());
        }
        if (!Validate.isNullOrEmpty((Object)id)) {
            return id;
        }
        return null;
    }

    private final Class<T> getEntry() {
        if (this.cls == null) {
            this.cls = (Class)Reflect.getGeneric(this.getClass());
        }
        return this.cls;
    }

    public Object postProcessBeforeInitialization(Object obj, String str) throws BeansException {
        return obj;
    }

    public Object postProcessAfterInitialization(Object obj, String str) throws BeansException {
        return obj;
    }
}

