package online.sanen.cdm.springSupport;

import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

/**
 * 
 * @author LazyToShow
 * Date: 2017/11/27
 * Time: 9:18
 */
public class SpringBeanFactory {
	
	static WebApplicationContext webApplicationContext;
	
	public static WebApplicationContext getContext() {
		if(webApplicationContext==null) {
			webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
		}
		return webApplicationContext;
	}
	
	public  static <T>T getBean(Class<T> cls) {
		return getContext().getBean(cls);
	}
	
	
	public Object getBean(String id) {
		return getContext().getBean(id);
	}
	
	public <T>T getBean(String id,Class<T> cls) {
		return getContext().getBean(id,cls);
	}

}
