package online.sanen.cdm.springSupport;

import java.util.HashMap;
import java.util.Map;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.web.bind.annotation.RequestMapping;

import com.mhdt.analyse.Validate;

@Aspect
public class MappingModule {

	@Around(value = "@within(org.springframework.stereotype.Controller)")
	public Object abc(ProceedingJoinPoint pjp) throws Throwable {
		
		if(Validate.isNullOrEmpty( pjp.proceed()) || !(pjp.proceed() instanceof String))
			return pjp.proceed();
		
		String value = getRequestMappingValue(pjp.getTarget().getClass());
		return value == null ? pjp.proceed() : value + "/" + pjp.proceed();
	}

	Map<Class<?>, String> rqtmvs = new HashMap<>();

	private String getRequestMappingValue(Class<? extends Object> cls) {

		if (rqtmvs.containsKey(cls)) {
			return rqtmvs.get(cls);
		} else {

			String value = null;
			if (cls.getAnnotation(RequestMapping.class) != null)
				value = cls.getAnnotation(RequestMapping.class).value()[0];

			rqtmvs.put(cls, value);
			return value;
		}
	}

}
