package online.sanen.cdm.springSupport;

import java.util.List;

import online.sanen.cdm.basic.BasicBean;

/**
 * 
 * @author ���ó���ͷ
 * Date: 2017/10/26
 * Time: 11:59
 */
public abstract class GeneralServiceImple<T extends BasicBean> implements GeneralService<T>{

	@Override
	public int insert(T entry) {
		return verify().insert(entry);
	}

	@Override
	public int remove(Object primaryKey) {
		return verify().remove(primaryKey);
	}

	public int update(T entry) {
		return verify().update(entry);
	}

	@Override
	public T find(Object primaryKey) {
		return  verify().find(primaryKey);
	}
	
	
	
	@Override
	public T find(String fieldName, Object value) {
		return verify().find(fieldName, value);
	}

	@Override
	public int remove(String fieldName, Object obj) {
		return verify().remove(fieldName, obj);
	}

	@Override
	public List<T> all() {
		return verify().all();
	}

	@Override
	public Object maximumkey() {
		return verify().maximumkey();
	}
	
	

	@Override
	public int totalNumber() {
		return verify().totalNumber();
	}

	private GeneralDao<T> verify() {
		
		GeneralDao<T> dao = getGeneralDao();
		if(dao!=null)return dao;
		
		throw new GeneralOprationException(
				"Unable to perform the operation, the abstract getGeneralDao method is an empty implementation",new NullPointerException());
		
	}
	
	protected  abstract GeneralDao<T> getGeneralDao();
		
		

}
