package online.sanen.cdm.springSupport;

import java.util.List;

import online.sanen.cdm.basic.BasicBean;

/**
 * 
 * @author ���ó���ͷ
 * Date: 2017/10/26
 * Time: 11:59
 */
public interface GeneralService<T extends BasicBean> {
	
	public int insert(T entry);
	
	public int remove(Object primaryKey);
	
	public int update(T entry);
	
	public T find(Object primaryKey);
	
	/**
	 *  Search by field
	 * @param fieldName  -  field by table column
	 * @param value - value
	 * @return
	 */
	public T find(String fieldName,Object value);
	
	/**
	 * Remove by field
	 * @param fieldName - field by table column
	 * @param obj - value
	 * @return
	 */
	public int remove(String fieldName,Object obj);
	
	/**
	 * Gets the table all data
	 * @return
	 */
	public List<T> all();
	
	/**
	 * Gets the current table total
	 * @return
	 */
	public int totalNumber();
	
	/**
	 * Gets the maximum of the primary key
	 */
	public Object maximumkey();

}
