package online.sanen.cdm.springSupport;

import java.util.List;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

import com.mhdt.analyse.Validate;
import com.mhdt.annotation.TableName;
import com.mhdt.toolkit.Reflect;

import online.sanen.cdm.Bootstrap;
import online.sanen.cdm.QuerySQL;
import online.sanen.cdm.QueryTB;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.Condition.Conditions;

/**
 * 
 * @author LazyToShow <br>
 *         Date: 2017/10/26 <br>
 *         Time: 11:59
 */
public abstract class GeneralDaoImpl<T extends BasicBean>
		implements GeneralDao<T>, ApplicationListener<ContextRefreshedEvent>,BeanPostProcessor {

	private static ApplicationContext applicationContext = null;

	@SuppressWarnings("static-access")
	public final void onApplicationEvent(ContextRefreshedEvent event) {
		if (this.applicationContext == null) {
			this.applicationContext = event.getApplicationContext();
		}

		System.err.println("Init Cdm-for-Spring " + getEntry().getName());
	}

	@Override
	public final int insert(T entry) {

		return getBootstrap().query(entry).insert();
	}

	@Override
	public final int remove(Object object) {

		return getBootstrap().query(getEntry(), GenaralAnalyse.processPrimaryKey(object)).remove();
	}

	@Override
	public final int update(T entry) {
		return getBootstrap().query(entry).update();
	}

	@Override
	public final T find(Object primarykey) {
		return (T) getBootstrap().query(getEntry(), GenaralAnalyse.processPrimaryKey(primarykey)).find();
	}

	@Override
	public final List<T> all() {
		return getBootstrap().query(getDefaultTableName()).addEntry(getEntry()).list();
	}

	@Override
	public final Object maximumkey() {

		BasicBean basicBean;

		try {

			basicBean = (BasicBean) Reflect.newInstance(getEntry().getName());
			return getBootstrap().createSQL("SELECT MAX(?) FROM " + getDefaultTableName(), basicBean.getPrimarykey())
					.uniqueResult();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	@Override
	public final int totalNumber() {
		return getBootstrap().createSQL("select count(1) from " + getDefaultTableName()).uniqueResult();
	}

	@Override
	public final int remove(String fieldName, Object value) {
		return getBootstrap().query(getDefaultTableName()).addCondition(fieldName, Conditions.EQUALS, value).remove();
	}

	@Override
	public final T find(String fieldName, Object value) {
		return getBootstrap().query(getDefaultTableName()).addCondition(fieldName, Conditions.EQUALS, value)
				.addEntry(getEntry()).uniqueResult();
	}

	private String defaultTableName;

	private final String getDefaultTableName() {

		if (defaultTableName == null) {

			if (Reflect.hasAnnotation(getEntry(), TableName.class)) {
				defaultTableName = Reflect.getTableNameValue(getEntry()).toUpperCase();
			} else {
				defaultTableName = getEntry().getSimpleName().toUpperCase();
			}
		}

		return defaultTableName;

	}

	protected final QueryTB queryTB() {

		return getBootstrap().query(getDefaultTableName());
	}

	protected final QueryTB queryTBForEntry() {
		return getBootstrap().query(getDefaultTableName()).addEntry(getEntry());
	}

	protected final QuerySQL createSQL(String sql, Object... paramers) {
		return getBootstrap().createSQL(sql, paramers);
	}

	protected final QuerySQL createSQLForEntry(String sql, Object... paramers) {
		return getBootstrap().createSQL(sql, paramers).addEntry(getEntry());
	}

	private Bootstrap bootstrap;

	protected final Bootstrap getBootstrap() {

		if (bootstrap == null) {
			
			if (Validate.isNullOrEmpty(applyBootStrapBeanId())) {
				try {
					bootstrap = applicationContext.getBean(Bootstrap.class);
				}catch (NoUniqueBeanDefinitionException e) {
					bootstrap = applicationContext.getBeansOfType(Bootstrap.class).values().iterator().next();
				}
				
			}else {
				bootstrap = applicationContext.getBean(applyBootStrapBeanId(), Bootstrap.class);
			}
		}

		return bootstrap;
	}

	/**
	 * 
	 * Assin the BootStrap-Id pass override this method.
	 * 
	 * @return BootStrap-Id
	 */
	protected String applyBootStrapBeanId() {
		

		//Entry annotations
		String id = Reflect.getBootStrapID(getEntry().getClass());
		
		//Class annotations
		if(Validate.isNullOrEmpty(id))
			id = Reflect.getBootStrapID(this.getClass());

		if (!Validate.isNullOrEmpty(id))
			return id;
		else
			return null;
	}

	private Class<T> cls;

	@SuppressWarnings("unchecked")
	private final Class<T> getEntry() {
		if (cls == null)
			cls = (Class<T>) Reflect.getGeneric(this.getClass());
		return cls;
	}
	
	@Override
	public Object postProcessBeforeInitialization(Object obj, String str) throws BeansException {
		return obj;
	}

	@Override
	public Object postProcessAfterInitialization(Object obj, String str) throws BeansException {
		return obj;
	}

	
}
