package online.sanen.cdm.springSupport;

import java.util.List;

import online.sanen.cdm.basic.BasicBean;

/**
 * <pre>
 * @author LazyToShow 
 * Date: 2017/10/26 
 * Time: 11:59
 * </pre>
 */
public interface GeneralDao<T extends BasicBean> {

	public int insert(T entry);

	/**
	 * The primary key to remove
	 * 
	 * @param primarykey
	 *            - primaryKey value or basicEntry
	 * @return
	 */
	public int remove(Object primarykey);

	public int update(T entry);

	/**
	 * 
	 * The primary key to find
	 * @param primarykey - primaryKey value or basicEntry
	 * @return
	 */
	public T find(Object primarykey);

	/**
	 * Search by field
	 * 
	 * @param fieldName
	 *            - field by table column
	 * @param value
	 *            - value
	 * @return
	 */
	public T find(String fieldName, Object value);

	/**
	 * Remove by fieldRemove by field
	 * @param fieldName
	 * @param value
	 * @return
	 */
	public int remove(String fieldName, Object value);

	/**
	 * Gets the table all data
	 * 
	 * @return
	 */
	public List<T> all();

	/**
	 * Gets the maximum of the primary key
	 */
	public Object maximumkey();

	/**
	 * Gets the current table total
	 * @return
	 */
	public int totalNumber();


}
