/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.infomation;

import java.util.List;
import online.sanen.cdm.api.Bootstrap;
import online.sanen.cdm.api.DataInformation;
import online.sanen.cdm.api.basic.DataField;

public class OracleInfomation
extends DataInformation {
    public OracleInfomation(Bootstrap bootstrap) {
        super(bootstrap);
    }

    public List<String> getDatabases() {
        String sql = "select tablespace_name from dba_tablespaces;";
        return this.bootstrap.createSQL(sql).list();
    }

    public List<String> getTableNames() {
        String sql = "SELECT table_name FROM USER_TABLES";
        return this.bootstrap.createSQL(sql).list();
    }

    public List<DataField> getFields(String tableName) {
        if (tableName.contains(".")) {
            tableName = tableName.split("\\.")[1];
        }
        String sql = "SELECT t1.COLUMN_NAME name,t1.DATA_TYPE type,(SELECT comments FROM all_col_comments t2 WHERE t2.TABLE_NAME=t1.TABLE_NAME\n   AND COLUMN_NAME=t1.COLUMN_NAME)AS \"COMMENT\" FROM all_tab_columns t1 WHERE t1.TABLE_NAME=?";
        List list = this.bootstrap.createSQL(sql, new Object[]{tableName}).list(DataField.class);
        sql = "SELECT col.column_name FROM all_constraints con,all_cons_columns col WHERE con.constraint_name=col.constraint_name AND con.constraint_type='P' AND col.table_name=?";
        List pks = this.bootstrap.createSQL(sql, new Object[]{tableName}).list();
        if (pks != null) {
            list.forEach(item -> {
                if (pks.contains(item.getName())) {
                    item.setPrimary(true);
                }
            });
        }
        return list;
    }
}

