/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import com.mhdt.analyse.Validate;
import com.mhdt.degist.DegistTool;
import com.mhdt.toolkit.Reflect;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.template.SqlTemplate;
import online.sanen.cdm.template.jpa.Column;
import online.sanen.cdm.template.jpa.NoDB;
import online.sanen.cdm.template.jpa.NoInsert;
import online.sanen.cdm.template.jpa.NoUpdate;

public class TakeIntersectionFieldsHandler
implements Handel {
    static Map<String, HashSet<String>> tableColumnsCache = new HashMap<String, HashSet<String>>();

    public Object handel(ChannelContext structure, Object product) {
        if (structure.getFields() != null && structure.getFields().size() > 0) {
            structure.setCommonFields(structure.getFields());
            return null;
        }
        String tableName = structure.getTableName();
        HashSet<String> tableFields = this.getTableFields(tableName, structure);
        Set<String> entryFields = this.getEntryField(structure);
        entryFields = entryFields == null ? tableFields : new HashSet<String>(entryFields.stream().filter(item -> {
            item = item.toUpperCase();
            for (String s : tableFields) {
                if (!s.toUpperCase().equals(item)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList()));
        structure.setCommonFields(entryFields);
        return null;
    }

    private Set<String> getEntryField(ChannelContext structure) {
        if (structure.getEntityMap() != null) {
            Set<String> fs = structure.getEntityMap().keySet();
            if (structure.getExceptes() != null) {
                fs.removeAll(structure.getExceptes());
            }
            return fs;
        }
        if (structure.getEntityMaps() != null) {
            Set<String> fs = ((Map)structure.getEntityMaps().stream().findFirst().get()).keySet();
            if (structure.getExceptes() != null) {
                fs.removeAll(structure.getExceptes());
            }
            return fs;
        }
        Class cls = structure.getEntityClass();
        if (cls == null) {
            return null;
        }
        QueryType queryType = structure.getQueryType();
        HashSet<String> columns = new HashSet<String>();
        for (Field field : Reflect.getFields((Class)cls)) {
            if (Validate.hasAnnotation((Field)field, NoDB.class) || queryType.equals((Object)QueryType.update) && Validate.hasAnnotation((Field)field, NoUpdate.class) || queryType.equals((Object)QueryType.insert) && Validate.hasAnnotation((Field)field, NoInsert.class) || structure.getExceptes() != null && structure.getExceptes().stream().anyMatch(item -> item.toLowerCase().equals(field.getName().toLowerCase()))) continue;
            if (Validate.hasAnnotation((Field)field, Column.class) && !Validate.isNullOrEmpty((Object)field.getAnnotation(Column.class).name())) {
                columns.add(field.getAnnotation(Column.class).name());
                continue;
            }
            columns.add(field.getName().toLowerCase());
        }
        return columns;
    }

    private HashSet<String> getTableFields(String tableName, ChannelContext structure) {
        String md5 = DegistTool.md5((String)(structure.getUrl() + tableName + "CDM"), (DegistTool.Encode)DegistTool.Encode.HEX);
        if (tableColumnsCache.containsKey(md5)) {
            return tableColumnsCache.get(md5);
        }
        SqlTemplate template = structure.getTemplate();
        ProductType productType = structure.productType();
        HashSet result = ProductType.getColumnsFromTableName((ProductType)productType, (SqlTemplate)template, (String)tableName);
        tableColumnsCache.put(md5, result);
        return result;
    }

    public void remove(ChannelContext structure) {
        tableColumnsCache.remove(DegistTool.md5((String)(structure.getUrl() + structure.getTableName() + "CDM"), (DegistTool.Encode)DegistTool.Encode.HEX));
    }
}

