/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import com.mhdt.toolkit.Reflect;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.CdmQueryException;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.api.basic.DataField;
import online.sanen.cdm.api.basic.StreamConsumer;
import online.sanen.cdm.template.SqlTemplate;

public class StreamHandler
implements Handel {
    private Consumer<List<Map<String, Object>>> consumer;
    private Map<String, String> aliases;
    private int bufferSize = 10000;
    private int count;
    Function<List<DataField>, Object> function;
    StreamConsumer streamConsumer;

    public StreamHandler(int bufferSize, Consumer<List<Map<String, Object>>> datas) {
        this(bufferSize, datas, null);
    }

    public StreamHandler(int bufferSize, Consumer<List<Map<String, Object>>> consumer, Map<String, String> aliases) {
        this.consumer = consumer;
        this.aliases = aliases;
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
    }

    public StreamHandler(int count) {
        this.count = count;
    }

    public StreamHandler(int bufferSize, Function<List<DataField>, Object> consumer, StreamConsumer datas, Map<String, String> aliases) {
        if (bufferSize > 0) {
            this.bufferSize = bufferSize;
        }
        this.function = consumer;
        this.streamConsumer = datas;
        this.aliases = aliases;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object handel(ChannelContext structure, Object product) {
        String sql = structure.getSql().toString();
        Collection paramers = structure.getParamers().values();
        SqlTemplate template = structure.getTemplate();
        try (Connection connection = template.getDataSource().getConnection();){
            PreparedStatement ps = connection.prepareStatement(sql);
            this.initFetchSize(ps, structure.productType());
            int index = 1;
            for (Object object : paramers) {
                try {
                    Method method = Reflect.getMethod((Object)ps, (String)("set" + object.getClass().getSimpleName()), (Class[])new Class[]{Integer.TYPE, object.getClass()});
                    method.invoke((Object)ps, index++, object);
                }
                catch (Exception e) {
                    ps.setString(index++, object.toString());
                }
            }
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            ArrayList<DataField> dataFields = new ArrayList<DataField>();
            ArrayList<String> columns = new ArrayList<String>();
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                DataField dataField = new DataField();
                dataField.setName(metaData.getColumnLabel(i + 1));
                dataField.setCls(Class.forName(metaData.getColumnClassName(i + 1)));
                dataField.setType(metaData.getColumnTypeName(i + 1));
                dataFields.add(dataField);
                columns.add(dataField.getName());
            }
            LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
            Object object = null;
            if (this.function != null) {
                object = this.function.apply(dataFields);
            }
            if (this.count > 0) {
                while (rs.next()) {
                    list.add(this.populate(rs, columns));
                    if (list.size() != this.count) continue;
                }
                LinkedList<Map<String, Object>> linkedList = list;
                return linkedList;
            }
            while (rs.next()) {
                list.add(this.populate(rs, columns));
                if (list.size() != this.bufferSize) continue;
                if (this.streamConsumer != null) {
                    this.streamConsumer.accept(object, list);
                } else {
                    this.consumer.accept(list);
                }
                list.clear();
            }
            if (list.size() <= 0) return null;
            if (this.streamConsumer != null) {
                this.streamConsumer.accept(object, list);
                return null;
            }
            this.consumer.accept(list);
            return null;
        }
        catch (Exception e) {
            throw new CdmQueryException(e.getMessage());
        }
    }

    private Map<String, Object> populate(ResultSet rs, List<String> columns) {
        HashMap<String, Object> map = new HashMap<String, Object>(columns.size());
        columns.forEach(field -> {
            try {
                String key = this.aliases != null && this.aliases.containsKey(field) ? this.aliases.get(field) : field;
                Object value = rs.getObject((String)field);
                map.put(key, value);
            }
            catch (SQLException e) {
                throw new CdmQueryException((Exception)e);
            }
        });
        return map;
    }
}

