/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.factory;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.DataField;
import online.sanen.cdm.api.basic.StreamConsumer;
import online.sanen.cdm.handel.AssemblyConditionsHandler;
import online.sanen.cdm.handel.BatchOperationHandler;
import online.sanen.cdm.handel.CreateAndInsertSqlHandler;
import online.sanen.cdm.handel.DebugHandler;
import online.sanen.cdm.handel.ModifyParametersHandler;
import online.sanen.cdm.handel.PrimaryKeyAsConditionHandler;
import online.sanen.cdm.handel.QueryResultLimitHandler;
import online.sanen.cdm.handel.QueryResultPackingHandler;
import online.sanen.cdm.handel.SqlColumnsExtractHandler;
import online.sanen.cdm.handel.SqlConstructHandler;
import online.sanen.cdm.handel.StreamHandler;
import online.sanen.cdm.handel.TakeIntersectionFieldsHandler;

public class HandelFactory {
    static Handel sqlHandel;
    static Handel tableFieldHandel;
    static Handel conditionHandel;
    static Handel queryHandel;
    static Handel paramerHandel;
    static Handel debugHandel;
    static PrimaryKeyAsConditionHandler primaryKeyAsConditionHandel;
    static Handel limitHandel;
    static Handel batchUpdate;
    static Handel resultColumnsHandel;

    public static Handel sqlHandel() {
        if (sqlHandel == null) {
            sqlHandel = new SqlConstructHandler();
        }
        return sqlHandel;
    }

    public static Handel commonFieldHandel() {
        if (tableFieldHandel == null) {
            tableFieldHandel = new TakeIntersectionFieldsHandler();
        }
        return tableFieldHandel;
    }

    public static Handel conditionHandel() {
        if (conditionHandel == null) {
            conditionHandel = new AssemblyConditionsHandler();
        }
        return conditionHandel;
    }

    public static Handel resultHandel() {
        if (queryHandel == null) {
            queryHandel = new QueryResultPackingHandler();
        }
        return queryHandel;
    }

    public static Handel paramerHandel() {
        if (paramerHandel == null) {
            paramerHandel = new ModifyParametersHandler();
        }
        return paramerHandel;
    }

    public static Handel debugHandel() {
        if (debugHandel == null) {
            debugHandel = new DebugHandler();
        }
        return debugHandel;
    }

    public static Handel primaryKeyHandel() {
        if (primaryKeyAsConditionHandel == null) {
            primaryKeyAsConditionHandel = new PrimaryKeyAsConditionHandler();
        }
        return primaryKeyAsConditionHandel;
    }

    public static Handel limitHandel() {
        if (limitHandel == null) {
            limitHandel = new QueryResultLimitHandler();
        }
        return limitHandel;
    }

    public static Handel batchUpdate() {
        if (batchUpdate == null) {
            batchUpdate = new BatchOperationHandler();
        }
        return batchUpdate;
    }

    public static Handel streamHandel(int bufferSize, Function<List<DataField>, Object> consumer, StreamConsumer datas, Map<String, String> aliases) {
        return new StreamHandler(bufferSize, consumer, datas, aliases);
    }

    public static Handel streamHandel(int bufferSize, Consumer<List<Map<String, Object>>> datas, Map<String, String> aliases) {
        return new StreamHandler(bufferSize, datas, aliases);
    }

    public static Handel streamHandel(int count) {
        return new StreamHandler(count);
    }

    public static Handel resultColumnsHandel() {
        if (resultColumnsHandel == null) {
            resultColumnsHandel = new SqlColumnsExtractHandler();
        }
        return resultColumnsHandel;
    }

    public static Handel createAndInsert(String newTableName) {
        return new CreateAndInsertSqlHandler(newTableName);
    }
}

