/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.factory;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import online.sanen.cdm.BootstrapDevice;
import online.sanen.cdm.api.Bootstrap;
import online.sanen.cdm.api.basic.CdmStructuralException;
import online.sanen.cdm.api.basic.Configuration;
import online.sanen.cdm.api.basic.DriverOption;
import online.sanen.cdm.api.basic.FileConfiguration;
import online.sanen.cdm.api.basic.SimpleConfiguration;
import online.sanen.cdm.template.transaction.Transaction;

public class Bootstraps {
    static Map<Object, Bootstrap> exists = new HashMap<Object, Bootstrap>();
    static Map<Bootstrap, Transaction> transactions = new HashMap<Bootstrap, Transaction>();

    public static boolean contains(Object key) {
        return exists.containsKey(key);
    }

    public static Bootstrap get(Object key) {
        return exists.get(key);
    }

    public static Bootstrap put(Object bootStrapId, Bootstrap bootstrap) {
        exists.put(bootStrapId, bootstrap);
        return bootstrap;
    }

    public static Bootstrap remove(String bootstrapId) {
        return exists.remove(bootstrapId);
    }

    public static void removeByPrefix(String prefix) {
        ArrayList array = new ArrayList();
        exists.keySet().forEach(item -> {
            if (item.toString().startsWith(prefix)) {
                array.add(item.toString());
            }
        });
        array.forEach(exists::remove);
    }

    public static Bootstrap load(Consumer<SimpleConfiguration> consumer) {
        return Bootstraps.load(null, consumer);
    }

    public static Bootstrap loadByFileConfiguration(Consumer<FileConfiguration> consumer) {
        return Bootstraps.loadByFileConfiguration(null, consumer);
    }

    public static Bootstrap loadByFileConfiguration(Object bootStrapId, Consumer<FileConfiguration> consumer) {
        try {
            if (bootStrapId != null && exists.containsKey(bootStrapId)) {
                return exists.get(bootStrapId);
            }
            FileConfiguration configuration = new FileConfiguration();
            consumer.accept(configuration);
            BootstrapDevice bootstrap = new BootstrapDevice((Configuration)configuration, bootStrapId);
            if (bootstrap != null) {
                exists.put(bootStrapId, bootstrap);
            }
            return bootstrap;
        }
        catch (Exception e) {
            throw new CdmStructuralException((Throwable)e);
        }
    }

    public static Bootstrap load(Object bootStrapId, Consumer<SimpleConfiguration> configuration) {
        try {
            if (bootStrapId != null && exists.containsKey(bootStrapId)) {
                return exists.get(bootStrapId);
            }
            SimpleConfiguration conf = new SimpleConfiguration();
            configuration.accept(conf);
            BootstrapDevice bootstrap = new BootstrapDevice((Configuration)conf, bootStrapId);
            if (bootstrap != null) {
                exists.put(bootStrapId, bootstrap);
            }
            return bootstrap;
        }
        catch (Exception e) {
            throw new CdmStructuralException((Throwable)e);
        }
    }

    public static boolean isUniqueness() {
        return exists.size() == 1;
    }

    public static Bootstrap getFirst() {
        Optional findFirst = exists.keySet().stream().findFirst();
        return findFirst.isPresent() ? exists.get(findFirst.get()) : null;
    }

    public static void registedTransaction(Bootstrap bootstrap, Transaction transaction) {
        transactions.put(bootstrap, transaction);
    }

    public static BootstrapBuilder newBuilder(String bootstrapId) {
        return new BootstrapBuilder(bootstrapId);
    }

    public static class BootstrapBuilder {
        private Object bootStrapId;
        private String driver;
        private String username;
        private String password;
        private Boolean isShowSql;
        private String url;
        private String validationQuery;
        private Configuration.DataSouseType dataSouseType;
        private Boolean isFormat;
        private Boolean isCache;

        private BootstrapBuilder(String bootstrapId2) {
            Assert.notNull((Object)bootstrapId2, (String)"bootstrap cannot be null");
            this.bootStrapId = bootstrapId2;
        }

        public BootstrapBuilder setBootstrapId(Object bootStrapId) {
            this.bootStrapId = bootStrapId;
            return this;
        }

        public BootstrapBuilder setDriver(DriverOption driverOption) {
            this.driver = driverOption.getValue();
            return this;
        }

        public BootstrapBuilder setUsername(String username) {
            this.username = username;
            return this;
        }

        public BootstrapBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public BootstrapBuilder setShowSql(boolean isShowSql) {
            this.isShowSql = isShowSql;
            return this;
        }

        public BootstrapBuilder setIsCache(boolean isCache) {
            this.isCache = isCache;
            return this;
        }

        public BootstrapBuilder setIsFormat(boolean isFormat) {
            this.isFormat = isFormat;
            return this;
        }

        public BootstrapBuilder setUrl(String url) {
            this.url = url;
            return this;
        }

        public BootstrapBuilder setValidationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
            return this;
        }

        public BootstrapBuilder setDataSouseType(Configuration.DataSouseType dataSouseType) {
            this.dataSouseType = dataSouseType;
            return this;
        }

        public Bootstrap build() {
            return Bootstraps.load(this.bootStrapId, configuration -> {
                if (!Validate.isNullOrEmpty((Object)this.driver)) {
                    configuration.setDriverOption(this.driver);
                }
                if (!Validate.isNullOrEmpty((Object)this.username)) {
                    configuration.setUsername(this.username);
                }
                if (!Validate.isNullOrEmpty((Object)this.password)) {
                    configuration.setPassword(this.password);
                }
                if (!Validate.isNullOrEmpty((Object)this.isShowSql)) {
                    configuration.setShowSql(this.isShowSql.booleanValue());
                }
                if (!Validate.isNullOrEmpty((Object)this.isCache)) {
                    configuration.setShowSql(this.isCache.booleanValue());
                }
                if (!Validate.isNullOrEmpty((Object)this.isFormat)) {
                    configuration.setShowSql(this.isFormat.booleanValue());
                }
                if (!Validate.isNullOrEmpty((Object)this.url)) {
                    configuration.setUrl(this.url);
                }
                if (!Validate.isNullOrEmpty((Object)this.validationQuery)) {
                    configuration.setValidationQuery(this.validationQuery);
                }
                if (!Validate.isNullOrEmpty((Object)this.dataSouseType)) {
                    configuration.setDataSouseType(this.dataSouseType);
                }
            });
        }
    }
}

