/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.toolkit.Assert;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.api.QueryTable;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.api.basic.DataField;
import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ResultType;
import online.sanen.cdm.api.basic.Sorts;
import online.sanen.cdm.api.basic.StreamConsumer;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.api.component.Pipeline;
import online.sanen.cdm.api.component.PipelineDivice;
import online.sanen.cdm.api.condition.C;
import online.sanen.cdm.api.condition.Condition;
import online.sanen.cdm.api.factory.PipelineFactory;
import online.sanen.cdm.factory.HandelFactory;
import online.sanen.cdm.template.SqlTemplate;

public class QueryTableDevice
implements QueryTable {
    ChannelContext structure;

    public QueryTableDevice(Manager manager, String tableName) {
        Assert.notNullOrEmpty((Object)tableName, (String)"Table name is null or empty");
        this.structure = new ChannelContext(manager);
        this.structure.setTableName(tableName);
    }

    public QueryTable addCondition(String fieldName, Condition.Cs cs) {
        this.structure.addCondition((Condition)C.buid((String)fieldName, (Condition.Cs)cs));
        return this;
    }

    public QueryTable addCondition(String fieldName, Condition.Cs cs, Object value) {
        this.structure.addCondition((Condition)C.buid((String)fieldName, (Condition.Cs)cs, (Object)value));
        return this;
    }

    public QueryTable addCondition(Condition cond) {
        if (cond == null) {
            return this;
        }
        this.structure.addCondition(cond);
        return this;
    }

    public QueryTable addCondition(Consumer<List<Condition>> consumer) {
        if (consumer == null) {
            return this;
        }
        consumer.accept(this.structure.getConditions());
        return this;
    }

    public QueryTable sort(final Sorts sorts, final String ... fields) {
        if (sorts == null) {
            return this;
        }
        this.structure.setSortSupport(new ChannelContext.SortSupport(){

            public String toString() {
                StringBuilder sb = new StringBuilder(" order by ");
                for (String field : fields) {
                    sb.append(field + ",");
                }
                sb.setLength(sb.length() - 1);
                sb.append(" " + sorts.getValue());
                return sb.toString();
            }
        });
        return this;
    }

    public QueryTable setFields(String ... fields) {
        if (fields == null) {
            return this;
        }
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryTable setExceptFields(String ... fields) {
        if (fields == null) {
            return this;
        }
        this.structure.setExceptes(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public <T> T unique() {
        return (T)Assembler.create(QueryType.select, ResultType.Object, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public <T> List<T> list() {
        return (List)Assembler.create(QueryType.select, ResultType.List, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.limitHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Consumer<List<Map<String, Object>>> consumer) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, null));
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Consumer<List<Map<String, Object>>> consumer, final Map<String, String> aliases) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, aliases));
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Function<List<DataField>, Object> consumer, final StreamConsumer datas, final Map<String, String> aliases) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, datas, aliases));
                return pipeline;
            }
        });
    }

    public List<Map<String, Object>> maps() {
        return (List)Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.limitHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int delete() {
        return (Integer)Assembler.create(QueryType.delete, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public QueryTable limit(Integer ... args) {
        if (args == null) {
            return this;
        }
        this.structure.setLimit(args);
        this.structure.setHasLimitAble(true);
        return this;
    }

    public boolean isExsites() {
        try {
            SqlTemplate template = this.structure.getTemplate();
            template.queryForRowSet("SELECT 1 FROM " + this.structure.getTableName(), new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int updateName(String newName) {
        this.structure.setSql(ProductType.updateTableNameSQL((ProductType)this.structure.productType(), (String)this.structure.getTableName(), (String)newName));
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int clear() {
        return this.delete();
    }

    public int drop() {
        return (Integer)Assembler.create(QueryType.drop, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int addColumn(String columnName, String type) {
        this.structure.setSql("ALTER TABLE " + this.structure.getTableName() + " ADD COLUMN  " + columnName + " " + type);
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public String createAndInsert(final String newTableName) {
        return (String)Assembler.create(QueryType.select, ResultType.String, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.limitHandel());
                pipeline.addLast(HandelFactory.createAndInsert(newTableName));
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public <T> T unique(Class<T> cls) {
        this.structure.setEntityClass(cls);
        return this.unique();
    }

    public <T> List<T> list(Class<T> cls) {
        this.structure.setEntityClass(cls);
        return this.list();
    }

    public <T> List<T> entities(Class<T> cls) {
        this.structure.setEntityClass(cls);
        return (List)Assembler.create(QueryType.select, ResultType.Beans, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.limitHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }
}

