/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.api.QuerySql;
import online.sanen.cdm.api.basic.CdmConditionException;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.api.basic.DataField;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ResultType;
import online.sanen.cdm.api.basic.StreamConsumer;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.api.component.Pipeline;
import online.sanen.cdm.api.component.PipelineDivice;
import online.sanen.cdm.api.factory.PipelineFactory;
import online.sanen.cdm.api.resource.R;
import online.sanen.cdm.factory.HandelFactory;

public class QuerySqlDevice
implements QuerySql {
    ChannelContext structure;

    public QuerySqlDevice(Manager manager, String sql, Object ... paramers) {
        this.structure = new ChannelContext(manager);
        this.structure.setSql(sql);
        this.structure.setCls(this.getClass());
        this.addParamers(paramers);
    }

    public QuerySql addParamer(int index, Object paramer) {
        if (index < 1) {
            throw new CdmConditionException(R.strings.Exception_Parametric_Anomaly);
        }
        if (paramer == null) {
            throw new CdmConditionException(R.strings.Exception_Parametric_Null);
        }
        this.structure.addParamer(index, paramer);
        return this;
    }

    public int update() {
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public <T> List<T> list() {
        return (List)Assembler.create(QueryType.select, ResultType.List, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public List<Map<String, Object>> maps() {
        return (List)Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Consumer<List<Map<String, Object>>> consumer) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, null));
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Consumer<List<Map<String, Object>>> consumer, Map<String, String> aliases) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, null));
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Function<List<DataField>, Object> consumer, final StreamConsumer datas, final Map<String, String> aliases) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, datas, aliases));
                return pipeline;
            }
        });
    }

    public List<Map<String, Object>> stream(final int count) {
        return (List)Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.streamHandel(count));
                return pipeline;
            }
        });
    }

    public Map<String, Object> map() {
        return (Map)Assembler.create(QueryType.select, ResultType.Map, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public <T> T unique() {
        return (T)Assembler.create(QueryType.select, ResultType.Object, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    private void addParamers(Object[] paramers) {
        if (paramers != null) {
            for (int i = 0; i < paramers.length; ++i) {
                this.addParamer(i + 1, paramers[i]);
            }
        }
    }

    public List<DataField> getQueryColumns() {
        return (List)Assembler.create(QueryType.select, ResultType.DataField, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultColumnsHandel());
                return pipeline;
            }
        });
    }

    public <T> List<T> list(Class<T> entityClass) {
        this.structure.setEntityClass(entityClass);
        return this.list();
    }

    public <T> List<T> entities(Class<T> entityClass) {
        this.structure.setEntityClass(entityClass);
        return (List)Assembler.create(QueryType.select, ResultType.Beans, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public <T> T unique(Class<T> entityClass) {
        this.structure.setEntityClass(entityClass);
        return this.unique();
    }
}

