/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.QueryUpdateDevice;
import online.sanen.cdm.api.QueryEntity;
import online.sanen.cdm.api.QueryUpdate;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ResultType;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.api.component.Pipeline;
import online.sanen.cdm.api.component.PipelineDivice;
import online.sanen.cdm.api.condition.C;
import online.sanen.cdm.api.condition.Condition;
import online.sanen.cdm.api.factory.PipelineFactory;
import online.sanen.cdm.factory.HandelFactory;

public class QueryEntityDevice
implements QueryEntity {
    ChannelContext structure;

    public QueryEntityDevice(Manager manager, Object entry) {
        this.structure = new ChannelContext(manager);
        this.structure.setEntity(entry);
    }

    public QueryEntityDevice(Manager manager, Collection<?> entrys) {
        this.structure = new ChannelContext(manager);
        this.structure.setEntities(entrys);
    }

    public QueryEntity setTableName(String tableName) {
        this.structure.setTableName(tableName);
        return this;
    }

    public QueryEntity setFields(String ... fields) {
        if (fields == null) {
            return this;
        }
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryEntity setExceptFields(String ... fields) {
        if (fields == null) {
            return this;
        }
        this.structure.setExceptes(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public int insert() {
        if (this.structure.getEntities() != null) {
            return this.batchUpdate(QueryType.insert);
        }
        return (Integer)Assembler.create(QueryType.insert, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int delete() {
        if (this.structure.getEntities() != null) {
            return this.batchUpdate(QueryType.delete);
        }
        return (Integer)Assembler.create(QueryType.delete, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.primaryKeyHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int update() {
        if (this.structure.getEntities() != null) {
            return this.batchUpdate(QueryType.update);
        }
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.primaryKeyHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    private int batchUpdate(QueryType type) {
        return (Integer)Assembler.create(type, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.batchUpdate());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public QueryUpdate addCondition(String fieldName, Condition.Cs cs) {
        this.structure.addCondition((Condition)C.buid((String)fieldName, (Condition.Cs)cs));
        return new QueryUpdateDevice(this.structure);
    }

    public QueryUpdate addCondition(String fieldName, Condition.Cs cs, Object value) {
        this.structure.addCondition((Condition)C.buid((String)fieldName, (Condition.Cs)cs, (Object)value));
        return new QueryUpdateDevice(this.structure);
    }

    public QueryUpdate addCondition(Condition cond) {
        this.structure.addCondition(cond);
        return new QueryUpdateDevice(this.structure);
    }

    public QueryUpdate addCondition(Consumer<List<Condition>> consumer) {
        consumer.accept(this.structure.getConditions());
        return new QueryUpdateDevice(this.structure);
    }

    public int create() {
        return (Integer)Assembler.create(QueryType.create, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }
}

