/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.toolkit.StringUtility;
import java.sql.Connection;
import online.sanen.cdm.api.basic.CdmQueryException;
import online.sanen.cdm.api.basic.Configuration;
import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.template.SqlTemplate;

public class ManagerDevice
implements Manager {
    SqlTemplate template;
    Configuration configuration;
    String id;
    String productName;

    public ManagerDevice(Object id) {
        this.setId(id);
    }

    public void setTemplate(SqlTemplate template) {
        this.template = template;
    }

    public String getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id == null ? null : String.valueOf(id);
    }

    public boolean isShowSql() {
        return this.configuration.isShowSql();
    }

    public SqlTemplate getTemplate() {
        return this.template;
    }

    public ProductType productType() {
        if (this.productName == null) {
            try (Connection conn = this.getTemplate().getDataSource().getConnection();){
                this.productName = conn.getMetaData().getDatabaseProductName().toUpperCase();
            }
            catch (Exception e) {
                throw new CdmQueryException(e.getMessage());
            }
        }
        return ProductType.valueOf((String)StringUtility.removeBlankChar((String)this.productName.replaceAll(" ", "_")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String databaseName() {
        try (Connection conn = this.template.getDataSource().getConnection();){
            String string = conn.getCatalog();
            return string;
        }
        catch (Exception e) {
            throw new CdmQueryException(e);
        }
    }

    public boolean isCache() {
        return this.configuration.isCache();
    }

    public boolean isLog() {
        return this.configuration.isLog();
    }

    public boolean isSqlFormat() {
        return this.configuration.isFormat();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUrl() {
        try (Connection conn = this.getTemplate().getDataSource().getConnection();){
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (Exception e) {
            throw new CdmQueryException(e);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

