/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.analyse.Validate;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import online.sanen.cdm.api.basic.ChannelContext;

public class CacheUtil {
    private static final String path = "resource/cache.xml";
    private URL url;
    private CacheManager manager;
    private static CacheUtil ehCache;
    public static String defaultCache;

    private CacheUtil(String path) {
        this.url = this.getClass().getResource(path);
        this.manager = CacheManager.create((URL)this.url);
    }

    public static CacheUtil getInstance() {
        if (ehCache == null) {
            ehCache = new CacheUtil(path);
        }
        return ehCache;
    }

    public void put(String cacheName, Object key, Object value) {
        Cache cache = this.manager.getCache(cacheName);
        Element element = new Element(key, value);
        cache.put(element);
    }

    public Object get(String cacheName, Object key) {
        Cache cache = this.manager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Element element = cache.get(key);
        return element == null ? null : element.getObjectValue();
    }

    public Cache getCache(String cacheName) {
        return this.manager.getCache(cacheName);
    }

    public void remove(String cacheName, String key) {
        Cache cache = this.manager.getCache(cacheName);
        cache.remove((Serializable)((Object)key));
    }

    public Cache createCache(String tabelName) {
        if (this.manager.cacheExists(tabelName)) {
            return this.manager.getCache(tabelName);
        }
        Cache memoryOnlyCache = new Cache(tabelName, 5000, false, false, 7200L, 7200L);
        this.manager.addCache(memoryOnlyCache);
        return memoryOnlyCache;
    }

    public String getCacheInfo(ChannelContext structure) {
        try {
            String cacheName = Validate.isNullOrEmpty((Object)structure.getTableName()) ? defaultCache : structure.getTableName();
            int size = this.getCache(cacheName).getSize();
            return cacheName + "/" + size + "/" + this.getCache(cacheName).getCacheConfiguration().getMaxElementsInMemory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    static {
        defaultCache = "temp";
    }
}

