/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.analyse.Template;
import com.mhdt.analyse.Validate;
import com.mhdt.log.Log;
import com.mhdt.log.LogFactory;
import com.mhdt.toolkit.Assert;
import java.util.Collection;
import java.util.Map;
import online.sanen.cdm.ManagerDevice;
import online.sanen.cdm.QueryEntityDevice;
import online.sanen.cdm.QueryMapDevice;
import online.sanen.cdm.QueryPKDevice;
import online.sanen.cdm.QuerySqlDevice;
import online.sanen.cdm.QueryTableDevice;
import online.sanen.cdm.api.Bootstrap;
import online.sanen.cdm.api.DataInformation;
import online.sanen.cdm.api.QueryEntity;
import online.sanen.cdm.api.QueryMap;
import online.sanen.cdm.api.QueryPK;
import online.sanen.cdm.api.QuerySql;
import online.sanen.cdm.api.QueryTable;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.CdmSupportsException;
import online.sanen.cdm.api.basic.Configuration;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.factory.DataSourceFactory;
import online.sanen.cdm.infomation.MSInfomation;
import online.sanen.cdm.infomation.MySQLInfomation;
import online.sanen.cdm.infomation.OracleInfomation;
import online.sanen.cdm.infomation.SQLiteInfomation;
import online.sanen.cdm.template.SqlTemplate;
import online.sanen.cdm.template.transaction.TransactionFactory;

public class BootstrapDevice
implements Bootstrap {
    final Log logger = LogFactory.getLog(Bootstrap.class);
    Manager manager;
    DataInformation dataInformation;

    public BootstrapDevice(Configuration configuration, Object id) {
        try {
            this.manager = new ManagerDevice(id);
            this.manager.setConfiguration(configuration);
            this.setTemplate(new SqlTemplate(DataSourceFactory.create(configuration)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTemplate(SqlTemplate template) {
        this.manager.setTemplate(template);
        Configuration configuration = this.manager.getConfiguration();
        if (configuration.isLog()) {
            Template tem = new Template(BootstrapDevice.class.getResourceAsStream("info.template"));
            tem.setParamer("dataBase", this.manager.productType().toString());
            tem.setParamer("url", this.manager.getUrl());
            this.logger.info((Object)tem.getText());
        }
    }

    public QuerySql createSQL(String sql, Object ... paramers) {
        if (Validate.isNullOrEmpty((Object)sql)) {
            throw new NullPointerException("Sql is null");
        }
        return new QuerySqlDevice(this.manager, sql, paramers);
    }

    public QuerySql createSQL(String sql) {
        if (Validate.isNullOrEmpty((Object)sql)) {
            throw new NullPointerException("Sql is null");
        }
        return new QuerySqlDevice(this.manager, sql, new Object[0]);
    }

    public QueryEntity query(Object entry) {
        if (entry == null) {
            throw new NullPointerException("Entry is null");
        }
        if (this.manager == null) {
            throw new NullPointerException("manager is null");
        }
        return new QueryEntityDevice(this.manager, entry);
    }

    public QueryTable queryTable(String tableName) {
        if (Validate.isNullOrEmpty((Object)tableName)) {
            throw new NullPointerException("Table is null");
        }
        return new QueryTableDevice(this.manager, tableName);
    }

    public <T> QueryPK<T> query(Class<T> entryCls, Object primarykey) {
        if (entryCls == null) {
            throw new NullPointerException("Entry class is null");
        }
        if (primarykey == null) {
            throw new NullPointerException("Primary Key is null");
        }
        return new QueryPKDevice<T>(this.manager, entryCls, primarykey);
    }

    public QueryEntity queryList(Collection<?> entrys) {
        return new QueryEntityDevice(this.manager, entrys);
    }

    public Manager manager() {
        return this.manager;
    }

    public DataInformation dataInformation() {
        if (this.dataInformation != null) {
            return this.dataInformation;
        }
        switch (this.manager().productType()) {
            case MYSQL: {
                this.dataInformation = new MySQLInfomation(this);
                break;
            }
            case MICROSOFT_SQL_SERVER: {
                this.dataInformation = new MSInfomation(this);
                break;
            }
            case SQLITE: {
                this.dataInformation = new SQLiteInfomation(this);
                break;
            }
            case ORACLE: {
                this.dataInformation = new OracleInfomation(this);
                break;
            }
            default: {
                throw new CdmSupportsException(this.manager().productType());
            }
        }
        return this.dataInformation;
    }

    public QueryMap queryMap(String tableName, Map<String, Object> map) {
        Assert.notNull((Object)tableName, (String)"TableName is null");
        Assert.notNull(map, (String)"Unable to create table \uff0cmap is null");
        return new QueryMapDevice(this.manager, tableName, map);
    }

    public QueryMap queryMap(String tableName, Collection<Map<String, Object>> entrys) {
        if (entrys == null || entrys.isEmpty()) {
            throw new NullPointerException("Entrys is null or empty.");
        }
        return new QueryMapDevice(this.manager, tableName, entrys);
    }

    public <T> QueryTable queryTable(Class<T> cls) {
        return this.queryTable(Cdm.table(cls));
    }

    public void bindTransaction(TransactionFactory factory) {
        this.manager.getTemplate().bindTransaction(factory);
    }
}

