/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.Print;
import online.sanen.cdm.CacheUtil;
import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ResultType;
import online.sanen.cdm.api.component.Pipeline;
import online.sanen.cdm.api.factory.PipelineFactory;

public class Assembler {
    public static ThreadLocal<StringBuilder> threadLocal = new ThreadLocal();

    public static Object create(QueryType queryType, ResultType resultType, ChannelContext context, PipelineFactory factory) {
        long lastTime = System.currentTimeMillis();
        context.setQueryType(queryType);
        context.setResultType(resultType);
        Object result = null;
        Pipeline pipeline = factory.getPipeline();
        try {
            for (Handel handel : pipeline.getHandels()) {
                Object message = handel.handel(context, result);
                Object object = result = message == null ? result : message;
                if (pipeline.getLast() != handel) continue;
                Assembler.print(lastTime, context);
                return result;
            }
        }
        catch (Exception e) {
            System.err.println(Cdm.getSql((ChannelContext)context));
            throw e;
        }
        return null;
    }

    private static void print(long lastTime, ChannelContext structure) {
        StringBuilder sb = threadLocal.get();
        if (structure.isShowSql()) {
            sb.append(Print.translate((String)"WHITE", (String)("Time: " + (float)(System.currentTimeMillis() - lastTime) / 1000.0f + "s ")));
            if (structure.isCache() && structure.getQueryType().equals((Object)QueryType.select)) {
                sb.append("\tcache:" + CacheUtil.getInstance().getCacheInfo(structure));
            }
            System.out.println(sb.toString() + "\r\n");
        }
    }
}

