package online.sanen.cdm.handel;

import com.mhdt.analyse.Validate;
import com.mhdt.degist.DegistTool;
import com.mhdt.degist.DegistTool.Encode;

import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import online.sanen.cdm.CacheUtil;
import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.ChannelContext;

/**
 * <pre>
 * 
 * &#64;author LazyToShow
 *  Date: 2017/10/21 
 *  Time: 23:19
 * </pre>
 */
public abstract class SimpleHandler implements Handel {

	protected void noticeUpdate(ChannelContext structure) {
		if (structure.getQueryType().equals(QueryType.select))
			return;

		String tabelName = Validate.isNullOrEmpty(structure.getTableName()) ? CacheUtil.defaultCache
				: structure.getTableName();
		Cache cache = CacheUtil.getInstance().getCache(tabelName);
		if (cache == null)
			return;

		cache.removeAll();
	}

	protected Object tryReadFromCache(ChannelContext structure) {
		if (!structure.getQueryType().equals(QueryType.select))
			return null;
		String tabelName = Validate.isNullOrEmpty(structure.getTableName()) ? CacheUtil.defaultCache
				: structure.getTableName();
		String md5 = DegistTool.md5(Cdm.getSql(structure), Encode.HEX);
		return CacheUtil.getInstance().get(tabelName, md5);

	}

	protected void noticeAdd(ChannelContext structure, Object result) {
		if (!structure.getQueryType().equals(QueryType.select))
			return;

		String tabelName = Validate.isNullOrEmpty(structure.getTableName()) ? CacheUtil.defaultCache
				: structure.getTableName();
		String md5 = DegistTool.md5(Cdm.getSql(structure), Encode.HEX);

		Cache cache = CacheUtil.getInstance().getCache(tabelName);
		if (cache == null)
			cache = CacheUtil.getInstance().createCache(tabelName);

		cache.put(new Element(md5, result));
	}

	// 换行且缩进
	static String[] Keywords = new String[] { "select", "insert into", "delete", "update", "from", "group by", "where",
			" values", "order by", "limit", "set" };
	// 换行
	static String[] Keywords2 = new String[] { " and ", " having " };

	// 大写
	static String[] Keywords3 = new String[] { " id ", " no ", " desc ", " set ", " top " };

	public String formatSql(ChannelContext context) {

		String sql = context.getSql().toString();

		for (String keyword : Keywords)
			sql = sql.replaceAll(keyword + "[\\s]+", "\r\n" + keyword.toUpperCase() + "\r\n ");

		for (String keyword : Keywords2)
			sql = sql.replaceAll(keyword, "\r\n  " + keyword.toUpperCase());

		for (String keyword : Keywords3)
			sql = sql.replaceAll(keyword, keyword.toUpperCase());

		context.setSql(sql);

		return Cdm.getSql(context);
	}

}
