package online.sanen.cdm.handel;

import static online.sanen.cdm.api.condition.C.buid;

import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.CdmQueryException;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.template.jpa.JPA.Primarykey;

/**
 * @author LazyToShow <br>
 * Date: 2017/11/23<br>
 * Time: 16:15<br>
 */
public class PrimaryKeyAsConditionHandler implements Handel {

	@Override
	public Object handel(ChannelContext structure, Object product) {

		Primarykey primaryKey = structure.getPrimaryKey();
		Object value = primaryKey.getValue();

		if (value == null) {

			if (structure.getEntity() != null)
				value = primaryKey.getValue(structure.getEntity());

			else
				throw new CdmQueryException(
						"Primary key related operations cannot be performed because the value is null");

		}

		structure.addCondition(buid(primaryKey.getName()).eq(value));
		return null;
	}

}
