package online.sanen.cdm.handel;

import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.template.jpa.JPA;

/**
 * Modify modify operation parameters.
 * 
 * @author LazyToShow <br>
 *         Date: 2017/10/21 <br>
 *         Time: 23:19
 */
public class ModifyParametersHandler implements Handel {

	@Override
	public Object handel(ChannelContext structure, Object product) {

		// Add the sort statement after the condition is processed
		if (structure.getSortSupport() != null)
			structure.getSql().append(structure.getSortSupport().toString());

		// If you customize the parameters
		if (structure.getParamers() != null && structure.getParamers().size() > 0)
			return null;

		switch (structure.getQueryType()) {

		case insert:
			processParamers(structure);
			break;

		case update:
			processParamers(structure);
			break;

		default:
			break;
		}

		return null;
	}

	private void processParamers(ChannelContext structure) {

		int index = 1;

		for (String column : structure.getCommonFields())
			if (structure.getEntity() != null)
				structure.addParamer(index++, JPA.getInject(structure.getEntity(), column));
			else
				structure.addParamer(index++, structure.getEntityMap().get(column));

	}

}
