package online.sanen.cdm.handel;

import java.util.Collection;

import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.template.SqlTemplate;

/**
 * 
 *
 * @author LazyToShow <br>
 *         Date: 2018/09/14 <br>
 *         Time: 10:09:06
 */
public class CreateAndInsertSqlHandler extends SimpleHandler {

	String newTableName;

	public CreateAndInsertSqlHandler(String newTableName) {
		this.newTableName = newTableName;
	}

	@Override
	public Object handel(ChannelContext structure, Object product) {
		String modifier = ProductType.applyTableModifier(structure.productType());
		structure.getSql().insert(0, "CREATE TABLE " + modifier + newTableName + modifier + " AS ");
		Collection<Object> paramers = structure.getParamers().values();
		SqlTemplate template = (SqlTemplate) structure.getTemplate();
		template.update(structure.getSql().toString(), paramers.toArray());
		return Cdm.getSql(structure);
	}

}
