package online.sanen.cdm.handel;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.mhdt.toolkit.Reflect;

import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.template.SqlTemplate;
import online.sanen.cdm.template.jpa.JPA;
import online.sanen.cdm.template.jpa.JPA.Primarykey;

/**
 * 
 * @author LazyToShow <br>
 *         Date: 2017/11/29 <br>
 *         Time： 11：51
 */
public class BatchOperationHandler extends SimpleHandler {

	/**
	 * The original return value of batch operations is an int array, and now it is
	 * omitted to return 1 or -1 to represent whether an exception has occurred
	 */
	@Override
	public Object handel(ChannelContext structure, Object product) {

		try {

			if ((structure.getEntities() == null || structure.getEntities().isEmpty())
					&& (structure.getEntityMaps() == null || structure.getEntityMaps().isEmpty()))
				return new NullPointerException("Batch operation data source is null");

			QueryType type = structure.getQueryType();
			SqlTemplate template = (SqlTemplate) structure.getTemplate();

			// Batch delete does not exist, this is to unify the interface to do the
			// adaptation,
			// delete the way to use in function, separate processing
			if (type.equals(QueryType.delete)) {

				Primarykey primaryKey = structure.getPrimaryKey();

				return batchRemove(template, structure.getEntities(), structure.getSql(), primaryKey);
			}

			// if update or insert should add where condition by primary key
			if (type.equals(QueryType.update)) {

				try {

					Object entity = structure.getEntities().stream().findFirst().get();
					appendPrimaryCondition(structure.getSql(), entity);

				} catch (NullPointerException e) {

				}

			}

			List<Object[]> paramer_objects = new ArrayList<>();

			if (structure.getEntityMaps() != null && !structure.getEntityMaps().isEmpty()) {

				for (Map<String, Object> map : structure.getEntityMaps()) {

					List<Object> paramers = new ArrayList<>();

					structure.getCommonFields().forEach(field -> {
						Object obj = map.get(field);

						if (obj instanceof Timestamp)
							obj = obj.toString();

						paramers.add(obj);
					});

					paramer_objects.add(paramers.toArray());
				}

			} else {

				for (Object entity : structure.getEntities()) {

					// if insert or update should add fields
					List<Object> paramers = new ArrayList<>();

					if (type.equals(QueryType.insert) || type.equals(QueryType.update))
						paramers.addAll(getValues(entity, structure.getCommonFields()));

					// if update should add primary key
					if (type.equals(QueryType.update))
						paramers.add(getPrimaryValua(entity));

					paramer_objects.add(paramers.toArray());
				}

			}

			// Handling transactions manually under Sqlite can effectively improve insert
			// speed
			if (structure.productType() != ProductType.ORACLE)
				template.execute("begin;");

			template.batchUpdate(structure.getSql().toString(), paramer_objects);

			if (structure.productType() != ProductType.ORACLE)
				template.execute("commit;");

			return 1;

		} catch (Exception e) {
			e.printStackTrace();
			return -1;
		}

	}

	/**
	 * Batch delete use in function
	 * 
	 * @param template
	 * @param entrys
	 * @param sql
	 * @param basicBean
	 * @return
	 */
	private Object batchRemove(SqlTemplate template, Collection<?> entrys, StringBuilder sql,
			Primarykey primarykey) {
		try {

			List<Object> paramers = new ArrayList<>();

			sql.append(" where " + primarykey.getName() + " in(");

			for (Object entry : entrys) {
				sql.append("?,");
				paramers.add(primarykey.getValue(entry));
			}

			sql.setLength(sql.length() - 1);
			sql.append(")");

			template.update(sql.toString(), paramers.toArray());
			return 1;

		} catch (Exception e) {
			e.printStackTrace();
			return -1;
		}

	}

	/**
	 * Add a primary key constraint
	 * 
	 * @param sql
	 * @param entry
	 */
	private void appendPrimaryCondition(StringBuilder sql, Object entity) {

		Primarykey primaryKey = Cdm.getPrimaryKey(entity.getClass());
		sql.append(" where " + primaryKey.getName() + "=?");
	}

	/**
	 * Get the primary key
	 * 
	 * @param entity
	 * @return
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws SecurityException
	 */
	private Object getPrimaryValua(Object entity)
			throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {

		Primarykey primaryKey = Cdm.getPrimaryKey(entity.getClass());
		return primaryKey.getValue(entity);

	}

	/**
	 * Gets the value of the common field
	 * 
	 * @param entity
	 * @param commonFields
	 * @return
	 */
	private List<Object> getValues(Object entity, Set<String> commonFields) {

		List<Object> list = new ArrayList<>();

		try {

			for (String field : commonFields) {
				Field f = Reflect.getField(entity, field);
				f = (f == null ? JPA.getFieldByAlias(entity, field) : f);
				list.add(f.get(entity));
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		return list;
	}

}
