package online.sanen.cdm.factory;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

import online.sanen.cdm.handel.BatchOperationHandler;
import online.sanen.cdm.handel.TakeIntersectionFieldsHandler;
import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.DataField;
import online.sanen.cdm.api.basic.StreamConsumer;
import online.sanen.cdm.handel.AssemblyConditionsHandler;
import online.sanen.cdm.handel.CreateAndInsertSqlHandler;
import online.sanen.cdm.handel.DebugHandler;
import online.sanen.cdm.handel.QueryResultLimitHandler;
import online.sanen.cdm.handel.ModifyParametersHandler;
import online.sanen.cdm.handel.PrimaryKeyAsConditionHandler;
import online.sanen.cdm.handel.SqlColumnsExtractHandler;
import online.sanen.cdm.handel.QueryResultPackingHandler;
import online.sanen.cdm.handel.SqlConstructHandler;
import online.sanen.cdm.handel.StreamHandler;

/**
 * 
 *<pre>
 * @author LazyToShow
 * Date: 2017/10/21
 * Time: 23:19
 * </pre>
 */
public class HandelFactory {
	
	static Handel sqlHandel;
	
	public static Handel sqlHandel() {
		if(sqlHandel==null)
			sqlHandel = new SqlConstructHandler();
		
		return sqlHandel;
	}
	
	static Handel tableFieldHandel;
	
	public static Handel commonFieldHandel() {
		if(tableFieldHandel==null)
			tableFieldHandel = new TakeIntersectionFieldsHandler();
		
		return tableFieldHandel;
	}
	
	static Handel conditionHandel;
	
	public static Handel conditionHandel() {
		if(conditionHandel==null)
			conditionHandel = new AssemblyConditionsHandler();
		
		return conditionHandel;
	}
	
	static Handel queryHandel;
	
	public static Handel resultHandel() {
		if(queryHandel==null)
			queryHandel = new QueryResultPackingHandler();
		
		return queryHandel;
	}
	
	static Handel paramerHandel;
	
	public static Handel paramerHandel() {
		if(paramerHandel==null)
			paramerHandel = new ModifyParametersHandler();
		
		return paramerHandel;
	}
	
	static Handel debugHandel;
	
	public static Handel debugHandel() {
		if(debugHandel==null)
			debugHandel = new DebugHandler();
		
		return debugHandel;
	}
	
	static PrimaryKeyAsConditionHandler primaryKeyAsConditionHandel;
	
	public static Handel primaryKeyHandel() {
		if(primaryKeyAsConditionHandel==null)
			primaryKeyAsConditionHandel = new PrimaryKeyAsConditionHandler();
		
		return primaryKeyAsConditionHandel;
	}


	static Handel limitHandel;
	
	public static Handel limitHandel() {
		if(limitHandel==null)
			limitHandel = new QueryResultLimitHandler();
		
		return limitHandel;
	}
	
	static Handel batchUpdate;

	public static Handel batchUpdate() {
		if(batchUpdate==null)
			batchUpdate = new BatchOperationHandler();
		
		
		return batchUpdate;
	}
	
	public static Handel streamHandel(int bufferSize, Function<List<DataField>, Object> consumer, StreamConsumer datas,Map<String, String> aliases) {
		return new StreamHandler(bufferSize,consumer,datas,aliases);
	}

	public static Handel streamHandel(int bufferSize,Consumer<List<Map<String,Object>>> datas, Map<String, String> aliases) {
		
		return new StreamHandler(bufferSize,datas,aliases);
	}

	
	public static Handel streamHandel(int count) {
		return new StreamHandler(count);
	}
	
	
	static Handel resultColumnsHandel;
	
	public static Handel resultColumnsHandel() {
		
		if(resultColumnsHandel==null)
			resultColumnsHandel = new SqlColumnsExtractHandler();
		
		return resultColumnsHandel;
	}

	
	public static Handel createAndInsert(String newTableName) {
		
		return new CreateAndInsertSqlHandler(newTableName);
	}
	

}
