package online.sanen.cdm;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

import online.sanen.cdm.api.QuerySql;
import online.sanen.cdm.api.basic.CdmConditionException;
import online.sanen.cdm.api.basic.DataField;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ResultType;
import online.sanen.cdm.api.basic.StreamConsumer;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.api.component.Pipeline;
import online.sanen.cdm.api.component.PipelineDivice;
import online.sanen.cdm.api.factory.PipelineFactory;
import online.sanen.cdm.api.resource.R;
import online.sanen.cdm.factory.HandelFactory;

/**
 * 
 *
 * @author online.sanen <br>
 *         Date:2017年11月30日 <br>
 *         Time:下午8:37:20
 */
public class QuerySqlDevice implements QuerySql {

	ChannelContext structure;

	public QuerySqlDevice(Manager manager, String sql, Object... paramers) {
		structure = new ChannelContext(manager);
		structure.setSql(sql);
		structure.setCls(this.getClass());
		addParamers(paramers);
	}

	@Override
	public QuerySql addParamer(int index, Object paramer) {

		if (index < 1)
			throw new CdmConditionException(R.strings.Exception_Parametric_Anomaly);

		if (paramer == null)
			throw new CdmConditionException(R.strings.Exception_Parametric_Null);

		structure.addParamer(index, paramer);
		return this;
	}

	@Override
	public int update() {

		return (int) Assembler.create(QueryType.update, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> List<T> list() {
		return (List<T>) Assembler.create(QueryType.select, ResultType.List, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Map<String, Object>> maps() {
		return (List<Map<String, Object>>) Assembler.create(QueryType.select, ResultType.Maps, structure,
				new PipelineFactory() {
					@Override
					public Pipeline getPipeline() {
						Pipeline pipeline = new PipelineDivice();
						pipeline.addLast(HandelFactory.resultHandel());
						pipeline.addLast(HandelFactory.debugHandel());
						return pipeline;
					}
				});
	}

	@Override
	public void stream(int bufferSize, Consumer<List<Map<String, Object>>> consumer) {

		Assembler.create(QueryType.select, ResultType.Maps, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, null));
				return pipeline;
			}
		});
	}

	@Override
	public void stream(int bufferSize, Consumer<List<Map<String, Object>>> consumer, Map<String, String> aliases) {

		Assembler.create(QueryType.select, ResultType.Maps, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, null));
				return pipeline;
			}
		});

	}

	@Override
	public void stream(int bufferSize, Function<List<DataField>, Object> consumer, StreamConsumer datas,
			Map<String, String> aliases) {
		Assembler.create(QueryType.select, ResultType.Maps, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, datas, aliases));
				return pipeline;
			}
		});

	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Map<String, Object>> stream(int count) {

		return (List<Map<String, Object>>) Assembler.create(QueryType.select, ResultType.Maps, structure,
				new PipelineFactory() {

					@Override
					public Pipeline getPipeline() {
						Pipeline pipeline = new PipelineDivice();
						pipeline.addLast(HandelFactory.streamHandel(count));
						return pipeline;
					}

				});
	}

	@SuppressWarnings("unchecked")
	@Override
	public Map<String, Object> map() {
		return (Map<String, Object>) Assembler.create(QueryType.select, ResultType.Map, structure,
				new PipelineFactory() {
					@Override
					public Pipeline getPipeline() {
						Pipeline pipeline = new PipelineDivice();
						pipeline.addLast(HandelFactory.resultHandel());
						pipeline.addLast(HandelFactory.debugHandel());
						return pipeline;
					}
				});
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T unique() {

		return (T) Assembler.create(QueryType.select, ResultType.Object, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
	}

	private void addParamers(Object[] paramers) {
		if (paramers != null) {
			for (int i = 0; i < paramers.length; i++) {
				addParamer(i + 1, paramers[i]);
			}
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<DataField> getQueryColumns() {

		return (List<DataField>) Assembler.create(QueryType.select, ResultType.DataField, structure,
				new PipelineFactory() {
					@Override
					public Pipeline getPipeline() {
						Pipeline pipeline = new PipelineDivice();
						pipeline.addLast(HandelFactory.resultColumnsHandel());
						return pipeline;
					}
				});

	}

	@Override
	public <T> List<T> list(Class<T> entityClass) {
		structure.setEntityClass(entityClass);
		return list();
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> List<T> entities(Class<T> entityClass) {

		structure.setEntityClass(entityClass);

		return (List<T>) Assembler.create(QueryType.select, ResultType.Beans, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
	}

	@Override
	public <T> T unique(Class<T> entityClass) {
		structure.setEntityClass(entityClass);
		return unique();
	}

}
