package online.sanen.cdm;

import java.sql.Connection;
import com.mhdt.toolkit.StringUtility;

import online.sanen.cdm.api.basic.CdmQueryException;
import online.sanen.cdm.api.basic.Configuration;
import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.template.SqlTemplate;

/**
 * 
 * @author LazyToShow <br>
 *         Date: 2017/10/21 <br>
 *         Time: 23:19
 */
public class ManagerDevice implements Manager {

	SqlTemplate template;
	
	Configuration configuration;

	String id;

	public ManagerDevice(Object id) {
		setId(id);
	}

	@Override
	public void setTemplate(SqlTemplate template) {
		this.template = template;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(Object id) {
		this.id = id == null ? null : String.valueOf(id);
	}

	@Override
	public boolean isShowSql() {
		return configuration.isShowSql();
	}

	public SqlTemplate getTemplate() {
		return template;
	}

	String productName;

	@Override
	public ProductType productType() {

		if (productName == null) {

			try (Connection conn = getTemplate().getDataSource().getConnection()) {
				productName = conn.getMetaData().getDatabaseProductName().toUpperCase();
			} catch (Exception e) {
				throw new CdmQueryException(e.getMessage());
			}
		}

		return ProductType.valueOf(StringUtility.removeBlankChar(productName.replaceAll(" ", "_")));
	}

	@Override
	public String databaseName() {

		try (Connection conn = template.getDataSource().getConnection()) {
			return conn.getCatalog();
		} catch (Exception e) {
			throw new CdmQueryException(e);
		}

	}

	@Override
	public boolean isCache() {
		return configuration.isCache();
	}

	public boolean isLog() {
		return configuration.isLog();
	}


	@Override
	public boolean isSqlFormat() {
		return configuration.isFormat();
	}

	@Override
	public String getUrl() {

		try (Connection conn = ((SqlTemplate) getTemplate()).getDataSource().getConnection()) {
			return conn.getMetaData().getURL();
		} catch (Exception e) {
			throw new CdmQueryException(e);
		}

	}

	@Override
	public Configuration getConfiguration() {
		return configuration;
	}

	@Override
	public void setConfiguration(Configuration configuration) {
		this.configuration = configuration;
	}

}
