package online.sanen.cdm;

import java.util.Collection;
import java.util.Map;


import com.mhdt.analyse.Template;
import com.mhdt.analyse.Validate;
import com.mhdt.log.Log;
import com.mhdt.log.LogFactory;
import com.mhdt.toolkit.Assert;

import online.sanen.cdm.api.Bootstrap;
import online.sanen.cdm.api.DataInformation;
import online.sanen.cdm.api.QueryEntity;
import online.sanen.cdm.api.QueryMap;
import online.sanen.cdm.api.QueryPK;
import online.sanen.cdm.api.QuerySql;
import online.sanen.cdm.api.QueryTable;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.CdmSupportsException;
import online.sanen.cdm.api.basic.Configuration;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.factory.DataSourceFactory;
import online.sanen.cdm.infomation.MSInfomation;
import online.sanen.cdm.infomation.MySQLInfomation;
import online.sanen.cdm.infomation.OracleInfomation;
import online.sanen.cdm.infomation.SQLiteInfomation;
import online.sanen.cdm.template.SqlTemplate;
import online.sanen.cdm.template.transaction.TransactionFactory;

/**
 * 
 * @author online.sanen <br>
 *         Date: 2017/10/21 <br>
 *         Time: 23:19
 */
public class BootstrapDevice implements Bootstrap {

	final Log logger = LogFactory.getLog(Bootstrap.class);

	Manager manager;

	public BootstrapDevice(Configuration configuration,Object id)  {
		
		try {
			manager = new ManagerDevice(id);
			manager.setConfiguration(configuration);
			setTemplate(new SqlTemplate(DataSourceFactory.create(configuration)));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}


	public void setTemplate(SqlTemplate template)  {

		manager.setTemplate(template);
		Configuration configuration = manager.getConfiguration();
		
		if (configuration.isLog()) {
			Template tem = new Template(BootstrapDevice.class.getResourceAsStream("info.template"));
			tem.setParamer("dataBase", manager.productType().toString());
			tem.setParamer("url", manager.getUrl());
			logger.info(tem.getText());
		}

	}

	@Override
	public QuerySql createSQL(String sql, Object... paramers) {

		if (Validate.isNullOrEmpty(sql))
			throw new NullPointerException("Sql is null");

		return new QuerySqlDevice(manager, sql, paramers);
	}

	@Override
	public QuerySql createSQL(String sql) {

		if (Validate.isNullOrEmpty(sql))
			throw new NullPointerException("Sql is null");

		return new QuerySqlDevice(manager, sql);
	}

	@Override
	public QueryEntity query(Object entry) {

		if (entry == null)
			throw new NullPointerException("Entry is null");

		if (manager == null)
			throw new NullPointerException("manager is null");

		return new QueryEntityDevice(manager, entry);
	}

	@Override
	public QueryTable queryTable(String tableName) {

		if (Validate.isNullOrEmpty(tableName))
			throw new NullPointerException("Table is null");

		return new QueryTableDevice(manager, tableName);
	}

	@Override
	public <T> QueryPK<T> query(Class<T> entryCls, Object primarykey) {

		if (entryCls == null)
			throw new NullPointerException("Entry class is null");

		if (primarykey == null)
			throw new NullPointerException("Primary Key is null");

		return new QueryPKDevice<T>(manager, entryCls, primarykey);
	}

	@Override
	public QueryEntity queryList(Collection<?> entrys) {
		return new QueryEntityDevice(manager, entrys);
	}

	@Override
	public Manager manager() {
		return manager;
	}

	DataInformation dataInformation;

	@Override
	public DataInformation dataInformation() {

		if (dataInformation != null)
			return dataInformation;

		switch (manager().productType()) {
		case MYSQL:
			dataInformation = new MySQLInfomation(this);
			break;

		case MICROSOFT_SQL_SERVER:
			dataInformation = new MSInfomation(this);
			break;

		case SQLITE:
			dataInformation = new SQLiteInfomation(this);
			break;

		case ORACLE:
			dataInformation = new OracleInfomation(this);
			break;

		default:
			throw new CdmSupportsException(manager().productType());
		}

		return dataInformation;
	}

	@Override
	public QueryMap queryMap(String tableName, Map<String, Object> map) {
		
		Assert.notNull(tableName, "TableName is null");
		Assert.notNull(map, "Unable to create table ，map is null");

		return new QueryMapDevice(manager, tableName, map);
	}

	@Override
	public QueryMap queryMap(String tableName, Collection<Map<String, Object>> entrys) {
		if (entrys == null || entrys.isEmpty())
			throw new NullPointerException("Entrys is null or empty.");

		return new QueryMapDevice(manager, tableName, entrys);
	}

	@Override
	public <T> QueryTable queryTable(Class<T> cls) {
		return queryTable(Cdm.table(cls));
	}

	@Override
	public void bindTransaction(TransactionFactory factory) {
		manager.getTemplate().bindTransaction(factory);
	}

}
