package online.sanen.cdm;

import com.mhdt.Print;

import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ResultType;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.ChannelContext;
import online.sanen.cdm.api.component.Pipeline;
import online.sanen.cdm.api.factory.PipelineFactory;

/**
 * 
 * @author online.sanen <br>
 *         Date: 2017/10/21 <br>
 *         Time: 23:19
 */
public class Assembler {

	/**
	 * 
	 * @param queryType
	 * @param resultType
	 * @param context
	 * @param factory
	 * @return
	 */
	public static Object create(QueryType queryType, ResultType resultType, ChannelContext context,
			PipelineFactory factory) {

		long lastTime = System.currentTimeMillis();
		context.setQueryType(queryType);
		context.setResultType(resultType);

		Object result = null;

		Pipeline pipeline = factory.getPipeline();

		try {

			for (Handel handel : pipeline.getHandels()) {
				Object message = handel.handel(context, result);
				result = (message == null ? result : message);

				if (pipeline.getLast() == handel) {
					print(lastTime, context);
					return result;
				}

			}

		} catch (Exception e) {
			System.err.println(Cdm.getSql(context));
			throw e;
		}

		return null;

	}

	public static ThreadLocal<StringBuilder> threadLocal = new ThreadLocal<>();

	private static void print(long lastTime, ChannelContext structure) {

		StringBuilder sb = threadLocal.get();

		if (structure.isShowSql()) {

			sb.append(Print.translate("WHITE", "Time: " + (System.currentTimeMillis() - lastTime) / 1000f + "s "));

			if (structure.isCache() && structure.getQueryType().equals(QueryType.select))
				sb.append("\tcache:" + CacheUtil.getInstance().getCacheInfo(structure));

			System.out.println(sb.toString() + "\r\n");
		}
	}

}
