/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Assert;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import online.sanen.cdm.SqlConversion;
import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.QuerySql;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.CdmConditionException;
import online.sanen.cdm.api.basic.CdmQueryException;
import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.basic.Structure;
import online.sanen.cdm.api.resource.R;
import online.sanen.cdm.template.jpa.JPA;

public class SqlConstructHandel
implements Handel {
    public Object handel(Structure structure, Object product) {
        structure.getParamers().clear();
        if (structure.getCls() != null && structure.getClass().isAssignableFrom(QuerySql.class)) {
            return null;
        }
        structure.getSql().setLength(0);
        String tableName = Cdm.processTableName((String)structure.getTableName(), (ProductType)structure.productType());
        if (Validate.isNullOrEmpty((Object)tableName)) {
            throw new CdmConditionException(R.strings.Exception_TableName_Null);
        }
        switch (structure.getQueryType()) {
            case insert: {
                this.createInsertSql(tableName, structure);
                break;
            }
            case delete: {
                this.createRemoveSql(tableName, structure);
                break;
            }
            case update: {
                this.createUpdateSql(tableName, structure);
                break;
            }
            case select: {
                this.createSelectSql(tableName, structure);
                break;
            }
            case create: {
                this.createCreateSql(tableName, structure);
                break;
            }
            case drop: {
                this.createDropSql(tableName, structure);
            }
        }
        return null;
    }

    private void createDropSql(String tableName, Structure structure) {
        structure.setSql("DROP TABLE " + tableName);
    }

    private void createCreateSql(String tableName, Structure structure) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        if (structure.getEntityMap() != null) {
            for (Map.Entry entry : structure.getEntityMap().entrySet()) {
                if (entry.getValue() == null) {
                    map.put((String)entry.getKey(), String.class);
                    continue;
                }
                map.put((String)entry.getKey(), entry.getValue().getClass());
            }
        } else {
            map = new ConcurrentHashMap(JPA.structured((Object)structure.getEntity()));
            structure.setPrimaryKey(Cdm.getPrimaryKey(structure.getEntity().getClass()));
        }
        if (structure.getFields() != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (structure.getFields().contains(entry.getKey())) continue;
                map.remove(entry.getKey());
            }
        } else if (structure.getExceptes() != null) {
            structure.getExceptes().forEach(map::remove);
        }
        Assert.notNullOrEmpty(map, (String)"An empty table cannot be created because no valid reserved fields are specified.");
        String sql = "CREATE TABLE " + tableName;
        sql = sql + "(" + SqlConstructHandel.organizationFields(structure.getPrimaryKey(), structure.productType(), map) + ")";
        structure.setSql(sql);
    }

    private static String organizationFields(final JPA.Primarykey primarykey, final ProductType productType, Map<String, Class<?>> map) {
        StringBuilder sb = new StringBuilder();
        String modifer = ProductType.applyTableModifier((ProductType)productType);
        for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
            sb.append(modifer + entry.getKey() + modifer + " ");
            sb.append("${" + entry.getValue().getSimpleName().toUpperCase() + "}");
            if (primarykey != null && primarykey.getName().equals(entry.getKey()) && Validate.isNumber(entry.getValue())) {
                sb.append(" ${PRIMARY}");
            }
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return new SqlConversion(){

            @Override
            public ProductType applyProductType() {
                return productType;
            }

            @Override
            public String applyPrimaryKey() {
                return primarykey.getName();
            }
        }.apply(sb.toString());
    }

    private void createSelectSql(String tableName, Structure structure) {
        StringBuilder sb = structure.getSql();
        String modifer = ProductType.applyTableModifier((ProductType)structure.productType());
        sb.append("SELECT ");
        for (String field : structure.getCommonFields()) {
            sb.append(modifer + field + modifer + ",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(" FROM " + tableName);
    }

    private void createUpdateSql(String tableName, Structure structure) {
        String modifer = ProductType.applyTableModifier((ProductType)structure.productType());
        structure.getSql().append("UPDATE " + tableName + " SET ");
        for (String field : structure.getCommonFields()) {
            structure.getSql().append(modifer + field + modifer + "=?,");
        }
        structure.getSql().setLength(structure.getSql().length() - 1);
    }

    private void createRemoveSql(String tableName, Structure structure) {
        structure.getSql().append("DELETE FROM " + tableName);
    }

    private void createInsertSql(String tableName, Structure structure) {
        if (structure.getCommonFields().isEmpty()) {
            throw new CdmQueryException("Cannot get generic fields from table: " + tableName);
        }
        String modifier = ProductType.applyTableModifier((ProductType)structure.productType());
        String sql = "INSERT INTO " + tableName + " (";
        String sql1 = " values (";
        for (String field : structure.getCommonFields()) {
            sql = sql + modifier + field + modifier + ",";
            sql1 = sql1 + "?,";
        }
        sql = sql.substring(0, sql.lastIndexOf(",")) + ")";
        sql1 = sql1.substring(0, sql1.lastIndexOf(",")) + ")";
        structure.getSql().append(sql + sql1);
    }
}

