/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import com.mhdt.toolkit.Reflect;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.Structure;
import online.sanen.cdm.handel.AbstractHandel;
import online.sanen.cdm.template.SqlTemplate;
import online.sanen.cdm.template.jpa.JPA;

public class BatchOperationHandel
extends AbstractHandel {
    public Object handel(Structure structure, Object product) {
        try {
            if ((structure.getEntities() == null || structure.getEntities().isEmpty()) && (structure.getEntityMaps() == null || structure.getEntityMaps().isEmpty())) {
                return new NullPointerException("Batch operation data source is null");
            }
            QueryType type = structure.getQueryType();
            SqlTemplate template = structure.getTemplate();
            if (type.equals((Object)QueryType.delete)) {
                JPA.Primarykey primaryKey = structure.getPrimaryKey();
                return this.batchRemove(template, structure.getEntities(), structure.getSql(), primaryKey);
            }
            if (type.equals((Object)QueryType.update)) {
                try {
                    Object entity = structure.getEntities().stream().findFirst().get();
                    this.appendPrimaryCondition(structure.getSql(), entity);
                }
                catch (NullPointerException entity) {
                    // empty catch block
                }
            }
            ArrayList<Object[]> paramer_objects = new ArrayList<Object[]>();
            if (structure.getEntityMaps() != null && !structure.getEntityMaps().isEmpty()) {
                for (Map map : structure.getEntityMaps()) {
                    ArrayList paramers = new ArrayList();
                    structure.getCommonFields().forEach(field -> {
                        Object obj = map.get(field);
                        if (obj instanceof Timestamp) {
                            obj = obj.toString();
                        }
                        paramers.add(obj);
                    });
                    paramer_objects.add(paramers.toArray());
                }
            } else {
                for (Object entity : structure.getEntities()) {
                    ArrayList<Object> paramers = new ArrayList<Object>();
                    if (type.equals((Object)QueryType.insert) || type.equals((Object)QueryType.update)) {
                        paramers.addAll(this.getValues(entity, structure.getCommonFields()));
                    }
                    if (type.equals((Object)QueryType.update)) {
                        paramers.add(this.getPrimaryValua(entity));
                    }
                    paramer_objects.add(paramers.toArray());
                }
            }
            if (structure.productType() != ProductType.ORACLE) {
                template.execute("begin;");
            }
            template.batchUpdate(structure.getSql().toString(), paramer_objects);
            if (structure.productType() != ProductType.ORACLE) {
                template.execute("commit;");
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private Object batchRemove(SqlTemplate template, Collection<?> entrys, StringBuilder sql, JPA.Primarykey primarykey) {
        try {
            ArrayList<Object> paramers = new ArrayList<Object>();
            sql.append(" where " + primarykey.getName() + " in(");
            for (Object entry : entrys) {
                sql.append("?,");
                paramers.add(primarykey.getValue(entry));
            }
            sql.setLength(sql.length() - 1);
            sql.append(")");
            template.update(sql.toString(), paramers.toArray());
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private void appendPrimaryCondition(StringBuilder sql, Object entity) {
        JPA.Primarykey primaryKey = Cdm.getPrimaryKey(entity.getClass());
        sql.append(" where " + primaryKey.getName() + "=?");
    }

    private Object getPrimaryValua(Object entity) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        JPA.Primarykey primaryKey = Cdm.getPrimaryKey(entity.getClass());
        return primaryKey.getValue(entity);
    }

    private List<Object> getValues(Object entity, Set<String> commonFields) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (String field : commonFields) {
                Field f = Reflect.getField((Object)entity, (String)field);
                f = f == null ? JPA.getFieldByAlias((Object)entity, (String)field) : f;
                list.add(f.get(entity));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

