/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import online.sanen.cdm.api.Handel;
import online.sanen.cdm.api.basic.CdmConditionException;
import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.basic.Structure;
import online.sanen.cdm.api.condition.CompositeCondition;
import online.sanen.cdm.api.condition.Condition;
import online.sanen.cdm.api.condition.SimpleCondition;

public class AssemblyConditionsHandel
implements Handel {
    public Object handel(Structure structure, Object product) {
        this.processCondition(structure);
        return null;
    }

    private void processCondition(Structure structure) {
        if (structure.getConditions() == null || structure.getConditions().isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(" WHERE ");
        AssemblyConditionsHandel.process(structure.productType(), sb, structure.getConditions(), obj -> structure.addParamer(obj));
        structure.getSql().append(sb.toString());
    }

    public static String process(ProductType productType, StringBuilder sb, List<? extends Condition> conditions, Consumer<Object> paramerValueConsumer) {
        String modifier = ProductType.applyTableModifier((ProductType)productType);
        for (Condition condition : conditions) {
            AssemblyConditionsHandel.processPefix(sb, condition);
            sb.append("(");
            if (condition instanceof CompositeCondition) {
                AssemblyConditionsHandel.process(productType, sb, ((CompositeCondition)condition).getConditions(), paramerValueConsumer);
                sb.append(")");
                continue;
            }
            SimpleCondition cond = (SimpleCondition)condition;
            if (cond.getCondition() == Condition.Cs.CONTAINS || cond.getCondition() == Condition.Cs.NO_CONTAINS || cond.getCondition() == Condition.Cs.START_WITH || cond.getCondition() == Condition.Cs.END_WITH) {
                try {
                    sb.append(modifier + cond.getFieldName() + modifier + cond.getCondition().annotation.replace("?", cond.getValue().toString()));
                }
                catch (NullPointerException e) {
                    throw new CdmConditionException("Condition value is null ," + condition.toString(), (Throwable)e);
                }
            } else if (cond.getCondition() == Condition.Cs.IN || cond.getCondition() == Condition.Cs.NOT_IN) {
                sb.append(modifier + cond.getFieldName() + modifier + cond.getCondition().annotation.replace("?", AssemblyConditionsHandel.processParamersOfIn(cond.getValue())));
                paramerValueConsumer.accept(cond.getValue());
            } else if (cond.getCondition() == Condition.Cs.MATCH) {
                sb.append("match(" + modifier + cond.getFieldName() + modifier + ")" + cond.getCondition().annotation);
                paramerValueConsumer.accept(cond.getValue());
            } else if (cond.getCondition() == Condition.Cs.IS_EMPTY || cond.getCondition() == Condition.Cs.IS_NULL || cond.getCondition() == Condition.Cs.IS_NOT_EMPTY || cond.getCondition() == Condition.Cs.IS_NOT_NULL) {
                sb.append(modifier + cond.getFieldName() + modifier + cond.getCondition().annotation);
            } else {
                sb.append(modifier + cond.getFieldName() + modifier + cond.getCondition().annotation);
                paramerValueConsumer.accept(cond.getValue());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private static CharSequence processParamersOfIn(Object value) {
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            StringBuilder sql = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                sql.append("?,");
            }
            sql.setLength(sql.length() - 1);
            return sql.toString();
        }
        if (value instanceof Collection) {
            Collection array = (Collection)value;
            StringBuilder sql = new StringBuilder();
            for (int i = 0; i < array.size(); ++i) {
                sql.append("?,");
            }
            sql.setLength(sql.length() - 1);
            return sql.toString();
        }
        return "?";
    }

    private static void processPefix(StringBuilder sql, Condition condition) {
        if (sql.toString().endsWith(" WHERE ") || sql.toString().endsWith("(")) {
            return;
        }
        if (condition.getAssociated() != Condition.Associated.AND) {
            sql.append(" OR ");
        } else {
            sql.append(" AND ");
        }
    }
}

