/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.factory;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mhdt.toolkit.Assert;
import java.util.Properties;
import javax.sql.DataSource;
import online.sanen.cdm.api.basic.Configuration;
import online.sanen.cdm.api.basic.Driven;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;

public class DataSourceFactory {
    public static DataSource create(Configuration configuration) throws Exception {
        Configuration.DataSouseType dataSouseType = configuration.dataSouseType();
        switch (dataSouseType) {
            case C3p0: {
                ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
                comboPooledDataSource.setJdbcUrl(configuration.url());
                comboPooledDataSource.setDriverClass(configuration.driver());
                comboPooledDataSource.setUser(configuration.username());
                comboPooledDataSource.setPassword(configuration.password());
                comboPooledDataSource.setPreferredTestQuery(configuration.validationQuery());
                if (configuration.driver().equals(Driven.ORACLE.getValue())) {
                    comboPooledDataSource.setPreferredTestQuery("SELECT 1 FROM DUAL");
                }
            }
            case Druid: {
                DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)DataSourceFactory.createProperties(configuration));
                druidDataSource.setTestOnBorrow(false);
                druidDataSource.setRemoveAbandoned(false);
                druidDataSource.setMaxWait(5000L);
                druidDataSource.setValidationQuery("SELECT 1");
                druidDataSource.setValidationQuery(configuration.validationQuery());
                if (configuration.driver().equals(Driven.ORACLE.getValue())) {
                    druidDataSource.setValidationQuery("SELECT 1 FROM DUAL");
                }
                return druidDataSource;
            }
        }
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)DataSourceFactory.createProperties(configuration));
        dataSource.setValidationQuery(configuration.validationQuery());
        if (configuration.driver().equals(Driven.ORACLE.getValue())) {
            dataSource.setValidationQuery("SELECT 1 FROM DUAL");
        }
        return dataSource;
    }

    private static Properties createProperties(final Configuration configuration) {
        Assert.notNull((Object)configuration.driver(), (String)"Driver is null from Obstract");
        Assert.notNull((Object)configuration.url(), (String)"Url is null from Obstract");
        return new Properties(){
            private static final long serialVersionUID = 1L;
            {
                this.setProperty("driverClassName", configuration.driver());
                this.setProperty("url", configuration.url());
                this.setProperty("username", configuration.username());
                this.setProperty("password", configuration.password());
                this.setProperty("validationQuery", "select 1");
            }
        };
    }
}

