/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import online.sanen.cdm.BootstrapDevice;
import online.sanen.cdm.api.Bootstrap;
import online.sanen.cdm.api.basic.BasicConfiguration;
import online.sanen.cdm.api.basic.CdmStructuralException;
import online.sanen.cdm.api.basic.Configuration;
import online.sanen.cdm.api.basic.FileConfiguration;
import online.sanen.cdm.template.transaction.Transaction;

public class BootstrapFactoty {
    static Map<Object, Bootstrap> cache = new HashMap<Object, Bootstrap>();
    static Map<Bootstrap, Transaction> transactions = new HashMap<Bootstrap, Transaction>();

    public static boolean contains(Object key) {
        return cache.containsKey(key);
    }

    public static Bootstrap get(Object key) {
        return cache.get(key);
    }

    public static Bootstrap put(Object bootStrapId, Bootstrap bootstrap) {
        cache.put(bootStrapId, bootstrap);
        return bootstrap;
    }

    public static Bootstrap remove(String bootstrapId) {
        return cache.remove(bootstrapId);
    }

    public static void removeByPrefix(String prefix) {
        ArrayList array = new ArrayList();
        cache.keySet().forEach(item -> {
            if (item.toString().startsWith(prefix)) {
                array.add(item.toString());
            }
        });
        array.forEach(cache::remove);
    }

    public static Bootstrap load(Consumer<BasicConfiguration> consumer) {
        return BootstrapFactoty.load(null, consumer);
    }

    public static Bootstrap loadByFileConfiguration(Consumer<FileConfiguration> consumer) {
        return BootstrapFactoty.loadByFileConfiguration(null, consumer);
    }

    public static Bootstrap loadByFileConfiguration(Object bootStrapId, Consumer<FileConfiguration> consumer) {
        try {
            if (bootStrapId != null && cache.containsKey(bootStrapId)) {
                return cache.get(bootStrapId);
            }
            FileConfiguration configuration = new FileConfiguration();
            consumer.accept(configuration);
            BootstrapDevice bootstrap = new BootstrapDevice((Configuration)configuration, bootStrapId);
            if (bootstrap != null) {
                cache.put(bootStrapId, bootstrap);
            }
            return bootstrap;
        }
        catch (Exception e) {
            throw new CdmStructuralException((Throwable)e);
        }
    }

    public static Bootstrap load(Object bootStrapId, Consumer<BasicConfiguration> consumer) {
        try {
            if (bootStrapId != null && cache.containsKey(bootStrapId)) {
                return cache.get(bootStrapId);
            }
            BasicConfiguration configuration = new BasicConfiguration();
            consumer.accept(configuration);
            BootstrapDevice bootstrap = new BootstrapDevice((Configuration)configuration, bootStrapId);
            if (bootstrap != null) {
                cache.put(bootStrapId, bootstrap);
            }
            return bootstrap;
        }
        catch (Exception e) {
            throw new CdmStructuralException((Throwable)e);
        }
    }

    public static boolean isUniqueness() {
        return cache.size() == 1;
    }

    public static Bootstrap getFirst() {
        Optional findFirst = cache.keySet().stream().findFirst();
        return findFirst.isPresent() ? cache.get(findFirst.get()) : null;
    }

    public static void registedTransaction(Bootstrap bootstrap, Transaction transaction) {
        transactions.put(bootstrap, transaction);
    }
}

