/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.api.QueryUpdate;
import online.sanen.cdm.api.basic.CdmConditionException;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ResultType;
import online.sanen.cdm.api.basic.Structure;
import online.sanen.cdm.api.component.Pipeline;
import online.sanen.cdm.api.component.PipelineDivice;
import online.sanen.cdm.api.condition.C;
import online.sanen.cdm.api.condition.Condition;
import online.sanen.cdm.api.factory.PipelineFactory;
import online.sanen.cdm.factory.HandelFactory;

public class QueryUpdateDevice
implements QueryUpdate {
    Structure structure;

    public QueryUpdateDevice(Structure structure) {
        this.structure = structure;
    }

    public QueryUpdate setTableName(String tableName) {
        this.structure.setTableName(tableName);
        return this;
    }

    public QueryUpdate setFields(String ... fields) {
        if (fields == null) {
            return this;
        }
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryUpdate setExceptFields(String ... fields) {
        if (fields == null) {
            return this;
        }
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryUpdate addCondition(String fieldName, Condition.Cs cs) {
        try {
            this.structure.addCondition((Condition)C.buid((String)fieldName, (Condition.Cs)cs));
        }
        catch (CdmConditionException e) {
            e.printStackTrace();
        }
        return this;
    }

    public QueryUpdate addCondition(String fieldName, Condition.Cs cs, Object value) {
        this.structure.addCondition((Condition)C.buid((String)fieldName, (Condition.Cs)cs, (Object)value));
        return this;
    }

    public QueryUpdate addCondition(Consumer<List<Condition>> consumer) {
        consumer.accept(this.structure.getConditions());
        return this;
    }

    public QueryUpdate addCondition(Condition cond) {
        if (cond == null) {
            return this;
        }
        this.structure.addCondition(cond);
        return new QueryUpdateDevice(this.structure);
    }

    public int update() {
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }
}

