/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import online.sanen.cdm.Assembler;
import online.sanen.cdm.api.QueryPK;
import online.sanen.cdm.api.basic.QueryType;
import online.sanen.cdm.api.basic.ResultType;
import online.sanen.cdm.api.basic.Structure;
import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.api.component.Pipeline;
import online.sanen.cdm.api.component.PipelineDivice;
import online.sanen.cdm.api.factory.PipelineFactory;
import online.sanen.cdm.factory.HandelFactory;

public class QueryPKDevice<T>
implements QueryPK<T> {
    Structure structure;

    public QueryPKDevice(Manager manager, Class<T> entryCls, Object primarykey) {
        this.structure = new Structure(manager);
        this.structure.getPrimaryKey().setValue(primarykey);
        this.structure.setEntityClass(entryCls);
    }

    public T find() {
        return (T)Assembler.create(QueryType.select, ResultType.Bean, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.primaryKeyHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int delete() {
        return (Integer)Assembler.create(QueryType.delete, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.primaryKeyHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }
}

