/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Assert;
import com.mhdt.toolkit.Reflect;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import online.sanen.cdm.api.Bootstrap;
import online.sanen.cdm.api.basic.Cdm;
import online.sanen.cdm.api.basic.CdmQueryException;
import online.sanen.cdm.api.basic.Sorts;
import online.sanen.cdm.api.condition.C;
import online.sanen.cdm.api.condition.Condition;
import online.sanen.cdm.factory.BootstrapFactoty;
import online.sanen.cdm.template.jpa.JPA;

public interface Behavior<T> {
    default public Perfect<T> setFields(String ... fields) {
        Perfect<T> perfect = this.perfect(this.bootstrap(), this, fields, null);
        return perfect;
    }

    default public Perfect<T> setExceptFields(String ... fields) {
        Perfect<T> perfect = this.perfect(this.bootstrap(), this, null, fields);
        return perfect;
    }

    default public int insert() {
        return this.perfect(this.bootstrap(), this, null, null).insert();
    }

    default public int delete() throws CdmQueryException {
        this.checkPrimary();
        return this.bootstrap().query((Object)this).delete();
    }

    default public void checkPrimary() {
        JPA.Primarykey primaryKey = Cdm.getPrimaryKey(this.getClass());
        Object primary = primaryKey.getValue((Object)this);
        Assert.notNull((Object)primary, (String)("The primary key is null:" + primaryKey + " " + this.getClass()));
    }

    default public int update(String ... fields) {
        this.checkPrimary();
        return this.setFields(fields).update();
    }

    default public Optional<T> findByPk() {
        return this.perfect(this.bootstrap(), this, null, null).findByPk();
    }

    default public Optional<T> findByFields(String ... fields) throws CdmQueryException {
        return this.perfect(this.bootstrap(), this, null, null).findByFields(fields);
    }

    default public int createTable() {
        return this.perfect(this.bootstrap(), this, null, null).createTable();
    }

    default public int dropTable() {
        String tableName = Cdm.table(this.getClass());
        if (this.bootstrap().query(tableName).isExsites()) {
            return this.bootstrap().query(tableName).drop();
        }
        return -1;
    }

    default public Bootstrap bootstrap() {
        String bootstrapId = JPA.getBootStrapId(this.getClass());
        if (Validate.isNullOrEmpty((Object)bootstrapId) && BootstrapFactoty.isUniqueness()) {
            return BootstrapFactoty.getFirst();
        }
        Assert.notNull((Object)bootstrapId, (String)("class:" + this.getClass().getName() + " There is no injected bootstrap instance, please use the @BootStrapID annotation."));
        if (BootstrapFactoty.contains(bootstrapId)) {
            return BootstrapFactoty.get(bootstrapId);
        }
        throw new NullPointerException("BootstrapId: '" + bootstrapId + "' index instance cannot be passed by class:" + this.getClass().getName());
    }

    public static <T> PerfectList<T> specify(Class<T> cls) {
        return Behavior.perfectList(Behavior.staticBootstrap(cls), cls);
    }

    public static <T> void batchInsert(List<T> list) throws CdmQueryException {
        Behavior.batchInsert(list);
    }

    public static <T> void batchInsert(List<T> list, String ... fields) {
        Assert.state((list != null && !list.isEmpty() ? 1 : 0) != 0, (String)"List is null or empty.");
        Class<?> class1 = list.get(0).getClass();
        Bootstrap bootstrap = Behavior.staticBootstrap(class1);
        Behavior.perfectList(bootstrap, class1).setFelds(fields).batchInsert(list);
    }

    public static <T> int delete(Class<T> cls, Consumer<List<Condition>> conditions) {
        return Behavior.staticBootstrap(cls).query(cls).addCondition(conditions).delete();
    }

    public static <T> void batchUpdate(List<T> list) {
        Behavior.batchUpdate(list);
    }

    public static <T> void batchUpdate(List<T> list, String ... fields) {
        Assert.state((list != null && !list.isEmpty() ? 1 : 0) != 0, (String)"List is null or empty.");
        Class<?> class1 = list.get(0).getClass();
        Bootstrap bootstrap = Behavior.staticBootstrap(class1);
        Behavior.perfectList(bootstrap, class1).setFelds(fields).batchUpdate(list);
    }

    public static <T> List<T> list(Class<T> cls) {
        return Behavior.perfectList(Behavior.staticBootstrap(cls), cls).list();
    }

    public static <T> List<T> list(Class<T> cls, Consumer<List<Condition>> consumer) {
        return Behavior.perfectList(Behavior.staticBootstrap(cls), cls).addCondtion(consumer).list();
    }

    public static <T> List<T> list(Class<T> cls, String ... fields) {
        Bootstrap $bootstrap = Behavior.staticBootstrap(cls);
        return Behavior.perfectList($bootstrap, cls).setFelds(fields).list();
    }

    public static <T> List<T> list(T t, String ... fields) {
        Class<?> $class = t.getClass();
        Bootstrap $bootstrap = Behavior.staticBootstrap($class);
        return Behavior.perfectList($bootstrap, $class).addCondtion(conditions -> {
            for (String fieldName : fields) {
                if (!Validate.hasField(t.getClass(), (String)fieldName)) continue;
                try {
                    conditions.add(C.eq((String)fieldName, (Object)Reflect.getValue((Object)t, (String)fieldName)));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
            }
        }).list();
    }

    public static Bootstrap staticBootstrap(Class<?> cls) {
        String bootStrapId = JPA.getBootStrapId(cls);
        return Validate.isNullOrEmpty((Object)bootStrapId) && BootstrapFactoty.isUniqueness() ? BootstrapFactoty.getFirst() : BootstrapFactoty.get(JPA.getBootStrapId(cls));
    }

    public static <T> PerfectList<T> perfectList(final Bootstrap $bootstrap, final Class<T> $class) {
        return new PerfectList<T>(){
            List<Condition> conditions = new ArrayList<Condition>();
            Integer[] limit;
            private String[] fields;
            private String[] excepts;
            Sorts sorts;
            private String[] sortFields;

            @Override
            public PerfectList<T> addCondition(Condition cond) {
                if (cond != null) {
                    this.conditions.add(cond);
                }
                return this;
            }

            @Override
            public PerfectList<T> addCondtion(Consumer<List<Condition>> conds) {
                if (conds != null) {
                    conds.accept(this.conditions);
                }
                return this;
            }

            @Override
            public PerfectList<T> sort(Sorts sorts, String ... fields) {
                this.sorts = sorts;
                this.sortFields = fields;
                return this;
            }

            @Override
            public PerfectList<T> limit(Integer ... limit) {
                this.limit = limit;
                return this;
            }

            @Override
            public PerfectList<T> setFelds(String ... fields) {
                this.fields = fields;
                return this;
            }

            @Override
            public PerfectList<T> setExcepts(String ... excepts) {
                this.excepts = excepts;
                return this;
            }

            @Override
            public void batchInsert(List<T> list) {
                Assert.notNull(list, (String)"List is null");
                $bootstrap.query(list).setFields(this.fields).setExceptFields(this.excepts).insert();
            }

            @Override
            public void batchUpdate(List<T> list) {
                Assert.notNull(list, (String)"List is null");
                $bootstrap.query(list).setFields(this.fields).setExceptFields(this.excepts).update();
            }

            @Override
            public List<T> list() {
                return $bootstrap.query($class).setFields(this.fields).setExceptFields(this.excepts).limit(this.limit).sort(this.sorts, this.sortFields).addCondition(conds -> conds.addAll(this.conditions)).entities($class);
            }

            @Override
            public int delete() {
                return $bootstrap.query($class).addCondition(conds -> conds.addAll(this.conditions)).delete();
            }
        };
    }

    default public Perfect<T> perfect(final Bootstrap $bootstrap, final Behavior<T> $bean, final String[] $fields, final String[] $excepts) {
        return new Perfect<T>(){

            @Override
            public int insert() {
                return $bootstrap.query((Object)$bean).setFields($fields).setExceptFields($excepts).insert();
            }

            @Override
            public int update() {
                return $bootstrap.query((Object)$bean).setFields($fields).setExceptFields($excepts).update();
            }

            @Override
            public Optional<T> findByPk() {
                JPA.Primarykey primaryKey = Cdm.getPrimaryKey($bean.getClass());
                Object value = primaryKey.getValue((Object)$bean);
                return Optional.ofNullable($bootstrap.query($bean.getClass()).setFields($fields).setExceptFields($excepts).addCondition(conditions -> conditions.add(C.buid((String)primaryKey.getName()).eq(value))).setFields($fields).setExceptFields($excepts).unique($bean.getClass()));
            }

            @Override
            public Optional<T> findByFields(String ... fields) {
                return Optional.ofNullable($bootstrap.query($bean.getClass()).setFields($fields).setExceptFields($excepts).addCondition(conditions -> {
                    for (String fieldName : fields) {
                        if (!Validate.hasField($bean.getClass(), (String)fieldName)) continue;
                        try {
                            conditions.add(C.eq((String)fieldName, (Object)Reflect.getValue((Object)$bean, (String)fieldName)));
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                            throw new CdmQueryException(e);
                        }
                    }
                }).unique($bean.getClass()));
            }

            @Override
            public int createTable() {
                if (!$bootstrap.query(Cdm.table($bean.getClass())).isExsites()) {
                    return $bootstrap.query((Object)$bean).setFields($fields).setExceptFields($excepts).create();
                }
                return -1;
            }
        };
    }

    public static interface Perfect<T> {
        public int insert();

        public int update();

        public Optional<T> findByPk();

        public Optional<T> findByFields(String ... var1);

        public int createTable();
    }

    public static interface PerfectList<T> {
        public PerfectList<T> addCondition(Condition var1);

        public PerfectList<T> addCondtion(Consumer<List<Condition>> var1);

        public PerfectList<T> sort(Sorts var1, String ... var2);

        public PerfectList<T> limit(Integer ... var1);

        public PerfectList<T> setFelds(String ... var1);

        public PerfectList<T> setExcepts(String ... var1);

        public void batchInsert(List<T> var1);

        public void batchUpdate(List<T> var1);

        public List<T> list();

        public int delete();
    }
}

