package online.sanen.cdm.factory;

import java.util.Properties;
import javax.sql.DataSource;

import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mhdt.toolkit.Assert;

import online.sanen.cdm.api.basic.Configuration;
import online.sanen.cdm.api.basic.Driven;
import online.sanen.cdm.api.basic.Configuration.DataSouseType;

/**
 * 
 * @author LazyToShow <br>
 *         Date: 2018/06/12 <br>
 *         Time: 09:17
 */
public class DataSourceFactory {

	public static DataSource create(final Configuration configuration) throws Exception {

		DataSouseType dataSouseType = configuration.dataSouseType();

		switch (dataSouseType) {

		case C3p0:

			ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
			comboPooledDataSource.setJdbcUrl(configuration.url());
			comboPooledDataSource.setDriverClass(configuration.driver());
			comboPooledDataSource.setUser(configuration.username());
			comboPooledDataSource.setPassword(configuration.password());
			comboPooledDataSource.setPreferredTestQuery(configuration.validationQuery());

			if (configuration.driver().equals(Driven.ORACLE.getValue()))
				comboPooledDataSource.setPreferredTestQuery("SELECT 1 FROM DUAL");

		case Druid:
			DruidDataSource druidDataSource = (DruidDataSource) DruidDataSourceFactory
					.createDataSource(createProperties(configuration));
			druidDataSource.setTestOnBorrow(false);
			druidDataSource.setRemoveAbandoned(false);
			druidDataSource.setMaxWait(5000);
			druidDataSource.setValidationQuery("SELECT 1");
			druidDataSource.setValidationQuery(configuration.validationQuery());

			if (configuration.driver().equals(Driven.ORACLE.getValue()))
				druidDataSource.setValidationQuery("SELECT 1 FROM DUAL");

			return druidDataSource;

		default:

			BasicDataSource dataSource = BasicDataSourceFactory.createDataSource(createProperties(configuration));
			dataSource.setValidationQuery(configuration.validationQuery());

			if (configuration.driver().equals(Driven.ORACLE.getValue()))
				dataSource.setValidationQuery("SELECT 1 FROM DUAL");

			return dataSource;
		}

	}

	private static Properties createProperties(Configuration configuration) {

		Assert.notNull(configuration.driver(), "Driver is null from Obstract");
		Assert.notNull(configuration.url(), "Url is null from Obstract");

		return new Properties() {
			private static final long serialVersionUID = 1L;
			{
				setProperty("driverClassName", configuration.driver());
				setProperty("url", configuration.url());
				setProperty("username", configuration.username());
				setProperty("password", configuration.password());
				setProperty("validationQuery", "select 1");
			}
		};

	}

}
