package online.sanen.cdm.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

import online.sanen.cdm.BootstrapDevice;
import online.sanen.cdm.api.Bootstrap;
import online.sanen.cdm.api.basic.BasicConfiguration;
import online.sanen.cdm.api.basic.CdmStructuralException;
import online.sanen.cdm.api.basic.FileConfiguration;
import online.sanen.cdm.template.transaction.Transaction;

/**
 * A {@link Bootstrap} instance is quickly created to replace the <b>new</b>
 * method, and it also has certain container functions
 * 
 * @author LazyToShow <br>
 *         Date: 2018/06/12 <br>
 *         Time: 09:17
 */
public class BootstrapFactoty {

	static Map<Object, Bootstrap> cache = new HashMap<>();

	public static boolean contains(Object key) {
		return cache.containsKey(key);
	}

	public static Bootstrap get(Object key) {

		return cache.get(key);
	}

	/**
	 * 
	 * @param bootStrapId
	 * @param bootstrap
	 * @return
	 */
	public static Bootstrap put(Object bootStrapId, Bootstrap bootstrap) {

		cache.put(bootStrapId, bootstrap);
		return bootstrap;

	}

	/**
	 * 
	 * @param bootstrapId
	 * @return
	 */
	public static Bootstrap remove(String bootstrapId) {
		return cache.remove(bootstrapId);
	}

	public static void removeByPrefix(String prefix) {

		List<String> array = new ArrayList<>();

		cache.keySet().forEach(item -> {
			if (item.toString().startsWith(prefix))
				array.add(item.toString());
		});

		array.forEach(cache::remove);
	}

	public static Bootstrap load(Consumer<BasicConfiguration> consumer) {
		return load(null, consumer);
	}
	
	public static Bootstrap loadByFileConfiguration(Consumer<FileConfiguration> consumer) {
		return loadByFileConfiguration(null, consumer);
	}

	public static Bootstrap loadByFileConfiguration(Object bootStrapId, Consumer<FileConfiguration> consumer) {
		
		try {

			if (bootStrapId != null && cache.containsKey(bootStrapId))
				return cache.get(bootStrapId);
			
			FileConfiguration configuration = new FileConfiguration();

			consumer.accept(configuration);
			
			Bootstrap bootstrap = new BootstrapDevice(configuration,bootStrapId);

			if (bootstrap != null)
				cache.put(bootStrapId, bootstrap);

			return bootstrap;

		} catch (Exception e) {
			throw new CdmStructuralException(e);
		}

	
	}

	public static Bootstrap load(Object bootStrapId, Consumer<BasicConfiguration> consumer) {

		try {

			if (bootStrapId != null && cache.containsKey(bootStrapId))
				return cache.get(bootStrapId);
			
			BasicConfiguration configuration = new BasicConfiguration();

			consumer.accept(configuration);
			
			Bootstrap bootstrap = new BootstrapDevice(configuration,bootStrapId);

			if (bootstrap != null)
				cache.put(bootStrapId, bootstrap);

			return bootstrap;

		} catch (Exception e) {
			throw new CdmStructuralException(e);
		}

	}

	/**
	 * Whether the BootStrap instance is unique
	 * 
	 * @return boolean
	 */
	public static boolean isUniqueness() {
		return cache.size() == 1;
	}

	/**
	 * Returns the first {@link Bootstrap} instance, or null if the cache is empty.
	 * 
	 * @return {@link Bootstrap}
	 */
	public static Bootstrap getFirst() {
		Optional<Object> findFirst = cache.keySet().stream().findFirst();
		return findFirst.isPresent() ? cache.get(findFirst.get()) : null;
	}

	static Map<Bootstrap, Transaction> transactions = new HashMap<>();

	/**
	 * 
	 * @param bootstrap
	 * @param transaction
	 */
	public static void registedTransaction(Bootstrap bootstrap, Transaction transaction) {

		transactions.put(bootstrap, transaction);
	}

}
