/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Bean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import online.sanen.cdm.Handel;
import online.sanen.cdm.QuerySQL;
import online.sanen.cdm.SqlConversion;
import online.sanen.cdm.basic.Cdm;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.CdmQueryException;
import online.sanen.cdm.basic.ProductType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.resource.R;

public class SqlHandel
implements Handel {
    public Object handel(Structure structure, Object product) {
        structure.getParamers().clear();
        if (structure.getCls() != null && structure.getClass().isAssignableFrom(QuerySQL.class)) {
            return null;
        }
        structure.getSql().setLength(0);
        String tableName = Cdm.processTableName((String)structure.getTableName(), (ProductType)structure.productType());
        if (Validate.isNullOrEmpty((Object)tableName)) {
            throw new CdmConditionException(R.strings.Exception_TableName_Null);
        }
        switch (structure.getQueryType()) {
            case insert: {
                this.createInsertSql(tableName, structure);
                break;
            }
            case delete: {
                this.createRemoveSql(tableName, structure);
                break;
            }
            case update: {
                this.createUpdateSql(tableName, structure);
                break;
            }
            case select: {
                this.createSelectSql(tableName, structure);
                break;
            }
            case create: {
                this.createCreateSql(tableName, structure);
                break;
            }
            case drop: {
                this.createDropSql(tableName, structure);
            }
        }
        return null;
    }

    private void createDropSql(String tableName, Structure structure) {
        structure.setSql("DROP TABLE " + tableName);
    }

    private void createCreateSql(String tableName, Structure structure) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        if (structure.getEnMap() != null) {
            for (Map.Entry entry : structure.getEnMap().entrySet()) {
                if (entry.getValue() == null) {
                    map.put((String)entry.getKey(), String.class.getSimpleName());
                    continue;
                }
                map.put((String)entry.getKey(), entry.getValue().getClass().getSimpleName());
            }
        } else {
            map = new ConcurrentHashMap(Bean.structured((Object)structure.getEntry()));
        }
        if (structure.getFields() != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (structure.getFields().contains(entry.getKey())) continue;
                map.remove(entry.getKey());
            }
        } else if (structure.getExceptes() != null) {
            structure.getExceptes().forEach(map::remove);
        }
        String modifer = ProductType.applyTableModifier((ProductType)structure.productType());
        String sql = "create table " + modifer + structure.getTableName() + modifer + "(" + SqlHandel.organizationFields(structure.getPrimaryKey(), structure.productType(), map) + ")";
        structure.setSql(sql);
    }

    private static String organizationFields(String primaryKey, ProductType productType, Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        String modifer = ProductType.applyTableModifier((ProductType)productType);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(modifer + entry.getKey() + modifer + " ");
            sb.append("${" + entry.getValue().toUpperCase() + "}");
            if (primaryKey != null && primaryKey.equals(entry.getKey()) && entry.getValue() == "Integer") {
                sb.append(" ${PRIMARY}");
            }
            sb.append(",");
        }
        SqlConversion function = () -> productType;
        try {
            sb.setLength(sb.length() - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new CdmConditionException("Build failures,SQL:" + sb.toString());
        }
        return function.apply(sb.toString());
    }

    private void createSelectSql(String tableName, Structure structure) {
        StringBuilder sb = structure.getSql();
        String modifer = ProductType.applyTableModifier((ProductType)structure.productType());
        sb.append("select ");
        for (String field : structure.getCommonFields()) {
            sb.append(modifer + field + modifer + ",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(" from " + tableName);
    }

    private void createUpdateSql(String tableName, Structure structure) {
        structure.getSql().append("update " + tableName + " set ");
        for (String field : structure.getCommonFields()) {
            structure.getSql().append(field + "=?,");
        }
        structure.getSql().setLength(structure.getSql().length() - 1);
    }

    private void createRemoveSql(String tableName, Structure structure) {
        structure.getSql().append("delete from " + tableName);
    }

    private void createInsertSql(String tableName, Structure structure) {
        if (structure.getCommonFields().isEmpty()) {
            throw new CdmQueryException("Cannot get generic fields from table: " + tableName);
        }
        String sql = "insert into " + tableName + " (";
        String sql1 = " values (";
        String modifier = ProductType.applyTableModifier((ProductType)structure.productType());
        for (String field : structure.getCommonFields()) {
            sql = sql + modifier + field + modifier + ",";
            sql1 = sql1 + "?,";
        }
        sql = sql.substring(0, sql.lastIndexOf(",")) + ")";
        sql1 = sql1.substring(0, sql1.lastIndexOf(",")) + ")";
        structure.getSql().append(sql + sql1);
    }
}

