/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.CdmQueryException;
import online.sanen.cdm.basic.DataField;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.template.JdbcTemplate;

public class SqlColumns
implements Handel {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object handel(Structure structure, Object product) {
        String sql = structure.getSql().toString();
        JdbcTemplate template = structure.getTemplate();
        try (Connection connection = template.getDataSource().getConnection();){
            PreparedStatement ps = connection.prepareStatement(sql, 1003, 1007);
            this.initFetchSize(ps, structure.productType());
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            ArrayList<DataField> dataFields = new ArrayList<DataField>();
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                DataField dataField = new DataField();
                dataField.setName(metaData.getColumnLabel(i + 1));
                dataField.setCls(Class.forName(metaData.getColumnClassName(i + 1)));
                dataField.setType(metaData.getColumnTypeName(i + 1));
                dataFields.add(dataField);
            }
            ArrayList<DataField> arrayList = dataFields;
            return arrayList;
        }
        catch (Exception e) {
            throw new CdmQueryException(e);
        }
    }
}

