/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import com.mhdt.toolkit.Bean;
import com.mhdt.toolkit.Collections;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.handel.CommonFieldHandel;
import online.sanen.cdm.handel.DefaultHandel;
import online.sanen.cdm.handel.Handels;
import online.sanen.cdm.template.GeneratedKeyHolder;
import online.sanen.cdm.template.JdbcTemplate;
import online.sanen.cdm.template.KeyHolder;
import online.sanen.cdm.template.SqlRowSet;

public class ResultHandel
extends DefaultHandel {
    public Object handel(Structure structure, Object product) {
        QueryType queryType = structure.getQueryType();
        if (queryType != QueryType.select) {
            if (structure.isCache()) {
                this.noticeUpdate(structure);
            }
            return this.update(queryType, structure);
        }
        String sql = structure.getSql().toString();
        Collection<Object> paramers = structure.getParamers().values();
        JdbcTemplate template = structure.getTemplate();
        ResultType resultType = structure.getResultType();
        Object result = null;
        if (structure.isCache() && (result = this.tryReadFromCache(structure)) != null) {
            return this.processCacheResult(result, resultType);
        }
        switch (resultType) {
            case Int: {
                result = this.queryForInt(sql, template, paramers);
                break;
            }
            case String: {
                result = this.queryForString(sql, template, paramers);
                break;
            }
            case List: {
                result = this.queryForList(structure, sql, template, paramers);
                break;
            }
            case Maps: {
                result = this.queryForMaps(sql, template, paramers);
                break;
            }
            case Map: {
                result = this.queryForMap(sql, template, paramers);
                break;
            }
            case Object: {
                result = this.queryForObject(structure, sql, template, paramers);
                break;
            }
            case Bean: {
                result = this.queryForBean(structure, sql, template, paramers);
                break;
            }
            case Beans: {
                result = this.queryForBeans(structure, sql, template, paramers);
                break;
            }
        }
        result = this.processLimit(result, structure);
        if (structure.isCache()) {
            this.noticeAdd(structure, result);
        }
        return result;
    }

    private Object update(QueryType queryType, Structure structure) {
        String sql = structure.getSql().toString();
        Object[] paramers = structure.getParamers().values().toArray();
        JdbcTemplate template = structure.getTemplate();
        if (queryType.equals((Object)QueryType.drop)) {
            CommonFieldHandel commonFieldHandel = (CommonFieldHandel)Handels.getCommonFieldHandel();
            commonFieldHandel.remove(structure);
        }
        if (queryType.equals((Object)QueryType.insert)) {
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            template.update(con -> {
                PreparedStatement ps = con.prepareStatement(sql, 1);
                for (int i = 0; i < paramers.length; ++i) {
                    ps.setObject(i + 1, paramers[i]);
                }
                return ps;
            }, (KeyHolder)keyHolder);
            try {
                return Optional.ofNullable(keyHolder.getKey()).map(mapper -> mapper.intValue()).orElse(1);
            }
            catch (Exception e) {
                return 1;
            }
        }
        return template.update(sql, paramers);
    }

    private Object processCacheResult(Object result, ResultType resultType) {
        if (result instanceof List && (resultType.equals((Object)ResultType.Object) || resultType.equals((Object)ResultType.Bean))) {
            return ((List)result).get(0);
        }
        return result;
    }

    private Object processLimit(Object result, Structure structure) {
        if (!(result instanceof List)) {
            return result;
        }
        if (structure.hasLimitAble() && !structure.isSupportLimitAble()) {
            Integer[] limit = structure.getLimit();
            Integer start = 0;
            Integer end = 0;
            if (limit.length == 1) {
                end = limit[0];
            } else if (limit.length == 2) {
                start = limit[0];
                end = limit[1];
                if (end == null) {
                    end = -1;
                }
            }
            result = Collections.limit((Collection)((List)result), (int)start, (int)end);
        }
        return result;
    }

    private Object queryForList(Structure structure, String sql, JdbcTemplate template, Collection<Object> paramers) {
        List<Map<String, Object>> list = this.queryForMaps(sql, template, paramers);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (structure.getEntry_class() == null) {
            return this.processList(list);
        }
        return Bean.parse((Class)structure.getEntry_class(), list);
    }

    private Object processList(List<Map<String, Object>> list) {
        if (list.get(0).keySet().size() > 1) {
            return list;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map<String, Object> map : list) {
            result.add(map.values().toArray()[0]);
        }
        return result;
    }

    private Object queryForBeans(Structure structure, String sql, JdbcTemplate template, Collection<Object> paramers) {
        List<Map<String, Object>> list = this.queryForMaps(sql, template, paramers);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return Bean.parse((Class)structure.getEntry_class(), list);
    }

    private Object queryForBean(Structure structure, String sql, JdbcTemplate template, Collection<Object> paramers) {
        Map<String, Object> map = this.queryForMap(sql, template, paramers);
        if (map == null || map.isEmpty()) {
            return null;
        }
        return Bean.parse((Class)structure.getEntry_class(), map);
    }

    private Object queryForObject(Structure structure, String sql, JdbcTemplate template, Collection<Object> paramers) {
        List<Map<String, Object>> maps = this.queryForMaps(sql, template, paramers);
        if (maps == null || maps.isEmpty()) {
            return null;
        }
        Map<String, Object> map = null;
        if (maps.size() > 0) {
            map = maps.get(0);
        }
        if (structure.getEntry_class() == null) {
            return map.size() > 1 ? map : this.processObjectByType(map.values().toArray()[0]);
        }
        return Bean.parse((Class)structure.getEntry_class(), map);
    }

    private Object processObjectByType(Object object) {
        long obj;
        if (object instanceof Long && (obj = ((Long)object).longValue()) < Integer.MAX_VALUE) {
            return (int)obj;
        }
        return object;
    }

    private List<Map<String, Object>> queryForMaps(String sql, JdbcTemplate template, Collection<Object> paramers) {
        return template.queryForList(sql, paramers.toArray());
    }

    private Map<String, Object> queryForMap(String sql, JdbcTemplate template, Collection<Object> paramers) {
        return template.queryForMap(sql, paramers.toArray());
    }

    private Object queryForString(String sql, JdbcTemplate template, Collection<Object> paramers) {
        SqlRowSet rs = template.queryForRowSet(sql, paramers.toArray());
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    private Object queryForInt(String sql, JdbcTemplate template, Collection<Object> paramers) {
        SqlRowSet rs = template.queryForRowSet(sql, paramers.toArray());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return -1;
    }
}

