/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import java.util.Collection;
import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.ProductType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.condition.Condition;

public class ConditionHandel
implements Handel {
    public Object handel(Structure structure, Object product) {
        this.processCondition(structure);
        return null;
    }

    private void processCondition(Structure structure) {
        if (structure.getConditions() == null || structure.getConditions().isEmpty()) {
            return;
        }
        structure.getSql().append(" WHERE ");
        String modifier = ProductType.applyTableModifier((ProductType)structure.productType());
        for (Condition condition : structure.getConditions()) {
            this.processPefix(structure.getSql(), condition);
            if (condition.getCondition() == Condition.Conditions.CONTAINS || condition.getCondition() == Condition.Conditions.NO_CONTAINS || condition.getCondition() == Condition.Conditions.START_WITH || condition.getCondition() == Condition.Conditions.END_WITH) {
                try {
                    structure.getSql().append(modifier + condition.getFieldName() + modifier + condition.getCondition().annotation.replace("?", condition.getValue().toString()));
                    continue;
                }
                catch (NullPointerException e) {
                    throw new CdmConditionException("Condition value is null ," + condition.toString(), (Throwable)e);
                }
            }
            if (condition.getCondition() == Condition.Conditions.IN || condition.getCondition() == Condition.Conditions.NOT_IN) {
                structure.getSql().append(modifier + condition.getFieldName() + modifier + condition.getCondition().annotation.replace("?", this.processParamersOfIn(condition.getValue())));
                structure.addParamer(condition.getValue());
                continue;
            }
            if (condition.getCondition() == Condition.Conditions.MATCH) {
                structure.getSql().append("match(" + modifier + condition.getFieldName() + modifier + ")" + condition.getCondition().annotation);
                structure.addParamer(condition.getValue());
                continue;
            }
            if (condition.getCondition() == Condition.Conditions.IS_EMPTY || condition.getCondition() == Condition.Conditions.IS_NULL || condition.getCondition() == Condition.Conditions.IS_NOT_EMPTY || condition.getCondition() == Condition.Conditions.IS_NOT_NULL) {
                structure.getSql().append(modifier + condition.getFieldName() + modifier + condition.getCondition().annotation);
                continue;
            }
            structure.getSql().append(modifier + condition.getFieldName() + modifier + condition.getCondition().annotation);
            structure.addParamer(condition);
        }
    }

    private CharSequence processParamersOfIn(Object value) {
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            StringBuilder sql = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                sql.append("?,");
            }
            sql.setLength(sql.length() - 1);
            return sql.toString();
        }
        if (value instanceof Collection) {
            Collection array = (Collection)value;
            StringBuilder sql = new StringBuilder();
            for (int i = 0; i < array.size(); ++i) {
                sql.append("?,");
            }
            sql.setLength(sql.length() - 1);
            return sql.toString();
        }
        return "?";
    }

    private void processPefix(StringBuilder sql, Condition condition) {
        if (sql.toString().endsWith(" WHERE ")) {
            return;
        }
        if (condition.getAssociated() != Condition.Associated.AND) {
            sql.append(" OR ");
        } else {
            sql.append(" AND ");
        }
    }
}

