/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import com.mhdt.analyse.Validate;
import com.mhdt.annotation.Column;
import com.mhdt.annotation.NoDB;
import com.mhdt.annotation.NoInsert;
import com.mhdt.annotation.NoUpdate;
import com.mhdt.degist.DegistTool;
import com.mhdt.toolkit.Reflect;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.ProductType;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.template.JdbcTemplate;

public class CommonFieldHandel
implements Handel {
    static Map<String, HashSet<String>> tableColumnsCache = new HashMap<String, HashSet<String>>();

    public Object handel(Structure structure, Object product) {
        if (structure.getFields() != null && structure.getFields().size() > 0) {
            structure.setCommonFields(structure.getFields());
            return null;
        }
        String tableName = structure.getTableName();
        HashSet<String> tableFields = this.getTableFields(tableName, structure);
        Set<String> entryFields = this.getEntryField(structure);
        entryFields = entryFields == null ? tableFields : new HashSet<String>(entryFields.stream().filter(item -> {
            item = item.toUpperCase();
            for (String s : tableFields) {
                if (!s.toUpperCase().equals(item)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList()));
        structure.setCommonFields(entryFields);
        return null;
    }

    private Set<String> getEntryField(Structure structure) {
        if (structure.getEnMap() != null) {
            Set<String> fs = structure.getEnMap().keySet();
            if (structure.getExceptes() != null) {
                fs.removeAll(structure.getExceptes());
            }
            return fs;
        }
        if (structure.getEnMaps() != null) {
            Set<String> fs = ((Map)structure.getEnMaps().stream().findFirst().get()).keySet();
            if (structure.getExceptes() != null) {
                fs.removeAll(structure.getExceptes());
            }
            return fs;
        }
        Class cls = structure.getEntry_class();
        if (cls == null) {
            return null;
        }
        QueryType queryType = structure.getQueryType();
        HashSet<String> columns = new HashSet<String>();
        for (Field field : Reflect.getFields((Class)cls)) {
            if (Validate.hasAnnotation((Field)field, NoDB.class) || queryType.equals((Object)QueryType.update) && Validate.hasAnnotation((Field)field, NoUpdate.class) || queryType.equals((Object)QueryType.insert) && Validate.hasAnnotation((Field)field, NoInsert.class) || structure.getExceptes() != null && structure.getExceptes().stream().anyMatch(item -> item.toLowerCase().equals(field.getName().toLowerCase()))) continue;
            if (Validate.hasAnnotation((Field)field, Column.class)) {
                columns.add(Reflect.getColumnValue((Field)field).toLowerCase());
                continue;
            }
            columns.add(field.getName().toLowerCase());
        }
        return columns;
    }

    private HashSet<String> getTableFields(String tableName, Structure structure) {
        String md5 = DegistTool.md5((String)(structure.getUrl() + tableName + "CDM"), (DegistTool.Encode)DegistTool.Encode.HEX);
        if (tableColumnsCache.containsKey(md5)) {
            return tableColumnsCache.get(md5);
        }
        JdbcTemplate template = structure.getTemplate();
        ProductType productType = structure.productType();
        HashSet result = ProductType.getColumnsFromTableName((ProductType)productType, (JdbcTemplate)template, (String)tableName);
        tableColumnsCache.put(md5, result);
        return result;
    }

    public void remove(Structure structure) {
        tableColumnsCache.remove(DegistTool.md5((String)(structure.getUrl() + structure.getTableName() + "CDM"), (DegistTool.Encode)DegistTool.Encode.HEX));
    }
}

