/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.handel;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Reflect;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.ProductType;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.handel.DefaultHandel;
import online.sanen.cdm.template.JdbcTemplate;

public class BatchUpdate
extends DefaultHandel {
    public Object handel(Structure structure, Object product) {
        try {
            if ((structure.getEntrys() == null || structure.getEntrys().isEmpty()) && (structure.getEnMaps() == null || structure.getEnMaps().isEmpty())) {
                return new NullPointerException("Batch operation data source is null");
            }
            QueryType type = structure.getQueryType();
            JdbcTemplate template = structure.getTemplate();
            if (type.equals((Object)QueryType.delete)) {
                BasicBean basicBean = (BasicBean)structure.getEntrys().stream().findFirst().get();
                String primaryKey = structure.getPrimaryKey();
                if (Validate.isNullOrEmpty((Object)primaryKey)) {
                    primaryKey = Validate.isNullOrEmpty((Object)basicBean.primarykey()) ? "id" : basicBean.primarykey();
                }
                return this.batchRemove(template, structure.getEntrys(), structure.getSql(), primaryKey);
            }
            if (type.equals((Object)QueryType.update)) {
                try {
                    BasicBean basicBean = (BasicBean)structure.getEntrys().stream().findFirst().get();
                    this.appendPrimaryCondition(structure.getSql(), basicBean);
                }
                catch (NullPointerException basicBean) {
                    // empty catch block
                }
            }
            ArrayList<Object[]> paramer_objects = new ArrayList<Object[]>();
            if (structure.getEnMaps() != null && !structure.getEnMaps().isEmpty()) {
                for (Map map : structure.getEnMaps()) {
                    ArrayList paramers = new ArrayList();
                    structure.getCommonFields().forEach(field -> {
                        Object obj = map.get(field);
                        if (obj instanceof Timestamp) {
                            obj = obj.toString();
                        }
                        paramers.add(obj);
                    });
                    paramer_objects.add(paramers.toArray());
                }
            } else {
                for (BasicBean entry : structure.getEntrys()) {
                    ArrayList<Object> paramers = new ArrayList<Object>();
                    if (type.equals((Object)QueryType.insert) || type.equals((Object)QueryType.update)) {
                        paramers.addAll(this.getValues(entry, structure.getCommonFields()));
                    }
                    if (type.equals((Object)QueryType.update)) {
                        paramers.add(this.getPrimaryValua(entry));
                    }
                    paramer_objects.add(paramers.toArray());
                }
            }
            if (structure.productType() != ProductType.ORACLE) {
                template.execute("begin;");
            }
            template.batchUpdate(structure.getSql().toString(), paramer_objects);
            if (structure.productType() != ProductType.ORACLE) {
                template.execute("commit;");
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private Object batchRemove(JdbcTemplate template, Collection<BasicBean> entrys, StringBuilder sql, String primaryKey) {
        try {
            ArrayList<Object> paramers = new ArrayList<Object>();
            sql.append(" where " + primaryKey + " in(");
            for (BasicBean entry : entrys) {
                sql.append("?,");
                paramers.add(Reflect.getValue((Object)entry, (String)primaryKey));
            }
            sql.setLength(sql.length() - 1);
            sql.append(")");
            template.update(sql.toString(), paramers.toArray());
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private void appendPrimaryCondition(StringBuilder sql, BasicBean basicBean) {
        String primaryKey = Validate.isNullOrEmpty((Object)basicBean.primarykey()) ? "id" : basicBean.primarykey();
        sql.append(" where " + primaryKey + "=?");
    }

    private Object getPrimaryValua(BasicBean basicBean) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        String primaryKey = Validate.isNullOrEmpty((Object)basicBean.primarykey()) ? "id" : basicBean.primarykey();
        return Reflect.getValue((Object)basicBean, (String)primaryKey);
    }

    private List<Object> getValues(BasicBean entry, Set<String> commonFields) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (String field : commonFields) {
                Field f = Reflect.getField((Object)entry, (String)field);
                f = f == null ? Reflect.getFieldByColumnValue((Object)entry, (String)field) : f;
                list.add(f.get(entry));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

